/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping.NxmNxTunId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxTunIdBuilder
implements Builder<NxmNxTunId> {
    private BigInteger _value;
    Map<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKVALUERANGE_RANGES;

    public NxmNxTunIdBuilder() {
    }

    public NxmNxTunIdBuilder(NxmNxTunId base) {
        Map aug;
        this._value = base.getValue();
        if (base instanceof NxmNxTunIdImpl) {
            NxmNxTunIdImpl impl = (NxmNxTunIdImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>(aug);
        }
    }

    public BigInteger getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<NxmNxTunId>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkValueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKVALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        CodeHelpers.throwInvalidRange((Object[])CHECKVALUERANGE_RANGES, (Object)value);
    }

    public NxmNxTunIdBuilder setValue(BigInteger value) {
        if (value != null) {
            NxmNxTunIdBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public NxmNxTunIdBuilder addAugmentation(Class<? extends Augmentation<NxmNxTunId>> augmentationType, Augmentation<NxmNxTunId> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxTunIdBuilder removeAugmentation(Class<? extends Augmentation<NxmNxTunId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxTunId build() {
        return new NxmNxTunIdImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKVALUERANGE_RANGES = a;
    }

    private static final class NxmNxTunIdImpl
    implements NxmNxTunId {
        private final BigInteger _value;
        private Map<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmNxTunIdImpl(NxmNxTunIdBuilder base) {
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxmNxTunId> getImplementedInterface() {
            return NxmNxTunId.class;
        }

        @Override
        public BigInteger getValue() {
            return this._value;
        }

        public <E$$ extends Augmentation<NxmNxTunId>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxTunId.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxTunId other = (NxmNxTunId)obj;
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxTunIdImpl otherImpl = (NxmNxTunIdImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxTunId>>, Augmentation<NxmNxTunId>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmNxTunId");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

