package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.original.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.NxRegLoad;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder} instances.
 *
 * @see NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder
 *
 */
public class NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder implements Builder<NxActionRegLoadRpcUpdateGroupOriginalCase> {

    private NxRegLoad _nxRegLoad;


    Map<Class<? extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>>, Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();

    public NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder() {
    }
    public NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping arg) {
        this._nxRegLoad = arg.getNxRegLoad();
    }

    public NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder(NxActionRegLoadRpcUpdateGroupOriginalCase base) {
        this._nxRegLoad = base.getNxRegLoad();
        if (base instanceof NxActionRegLoadRpcUpdateGroupOriginalCaseImpl) {
            NxActionRegLoadRpcUpdateGroupOriginalCaseImpl impl = (NxActionRegLoadRpcUpdateGroupOriginalCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>>, Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> aug =((AugmentationHolder<NxActionRegLoadRpcUpdateGroupOriginalCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping) {
            this._nxRegLoad = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping)arg).getNxRegLoad();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping]");
    }

    public NxRegLoad getNxRegLoad() {
        return _nxRegLoad;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder setNxRegLoad(final NxRegLoad value) {
        this._nxRegLoad = value;
        return this;
    }
    
    public NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> augmentationType, Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegLoadRpcUpdateGroupOriginalCase build() {
        return new NxActionRegLoadRpcUpdateGroupOriginalCaseImpl(this);
    }

    private static final class NxActionRegLoadRpcUpdateGroupOriginalCaseImpl implements NxActionRegLoadRpcUpdateGroupOriginalCase {
    
        private final NxRegLoad _nxRegLoad;
    
        private Map<Class<? extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>>, Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();
    
        NxActionRegLoadRpcUpdateGroupOriginalCaseImpl(NxActionRegLoadRpcUpdateGroupOriginalCaseBuilder base) {
            this._nxRegLoad = base.getNxRegLoad();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionRegLoadRpcUpdateGroupOriginalCase> getImplementedInterface() {
            return NxActionRegLoadRpcUpdateGroupOriginalCase.class;
        }
    
        @Override
        public NxRegLoad getNxRegLoad() {
            return _nxRegLoad;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegLoad);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegLoadRpcUpdateGroupOriginalCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegLoadRpcUpdateGroupOriginalCase other = (NxActionRegLoadRpcUpdateGroupOriginalCase)obj;
            if (!Objects.equals(_nxRegLoad, other.getNxRegLoad())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegLoadRpcUpdateGroupOriginalCaseImpl otherImpl = (NxActionRegLoadRpcUpdateGroupOriginalCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>>, Augmentation<NxActionRegLoadRpcUpdateGroupOriginalCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegLoadRpcUpdateGroupOriginalCase");
            CodeHelpers.appendValue(helper, "_nxRegLoad", _nxRegLoad);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
