package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder} instances.
 *
 * @see NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder
 *
 */
public class NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder implements Builder<NxActionEncapNotifGroupDescStatsUpdatedCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder() {
    }
    public NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }

    public NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder(NxActionEncapNotifGroupDescStatsUpdatedCase base) {
        this._nxEncap = base.getNxEncap();
        if (base instanceof NxActionEncapNotifGroupDescStatsUpdatedCaseImpl) {
            NxActionEncapNotifGroupDescStatsUpdatedCaseImpl impl = (NxActionEncapNotifGroupDescStatsUpdatedCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> aug =((AugmentationHolder<NxActionEncapNotifGroupDescStatsUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    public NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> augmentationType, Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapNotifGroupDescStatsUpdatedCase build() {
        return new NxActionEncapNotifGroupDescStatsUpdatedCaseImpl(this);
    }

    private static final class NxActionEncapNotifGroupDescStatsUpdatedCaseImpl implements NxActionEncapNotifGroupDescStatsUpdatedCase {
    
        private final NxEncap _nxEncap;
    
        private Map<Class<? extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> augmentation = Collections.emptyMap();
    
        NxActionEncapNotifGroupDescStatsUpdatedCaseImpl(NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder base) {
            this._nxEncap = base.getNxEncap();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionEncapNotifGroupDescStatsUpdatedCase> getImplementedInterface() {
            return NxActionEncapNotifGroupDescStatsUpdatedCase.class;
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxEncap);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionEncapNotifGroupDescStatsUpdatedCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionEncapNotifGroupDescStatsUpdatedCase other = (NxActionEncapNotifGroupDescStatsUpdatedCase)obj;
            if (!Objects.equals(_nxEncap, other.getNxEncap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionEncapNotifGroupDescStatsUpdatedCaseImpl otherImpl = (NxActionEncapNotifGroupDescStatsUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>>, Augmentation<NxActionEncapNotifGroupDescStatsUpdatedCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionEncapNotifGroupDescStatsUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxEncap", _nxEncap);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
