package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase> {

    private NxLearn _nxLearn;


    Map<Class<? extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping arg) {
        this._nxLearn = arg.getNxLearn();
    }

    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase base) {
        this._nxLearn = base.getNxLearn();
        if (base instanceof NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl) {
            NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl impl = (NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping) {
            this._nxLearn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping)arg).getNxLearn();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping]");
    }

    public NxLearn getNxLearn() {
        return _nxLearn;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder setNxLearn(final NxLearn value) {
        this._nxLearn = value;
        return this;
    }
    
    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase build() {
        return new NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl implements NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase {
    
        private final NxLearn _nxLearn;
    
        private Map<Class<? extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl(NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseBuilder base) {
            this._nxLearn = base.getNxLearn();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase> getImplementedInterface() {
            return NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase.class;
        }
    
        @Override
        public NxLearn getNxLearn() {
            return _nxLearn;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxLearn);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase other = (NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxLearn, other.getNxLearn())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionLearnNotifFlowsStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxLearn", _nxLearn);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
