package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.value._case.FlowModAddMatchFromValue;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModAddMatchFromValueCaseBuilder} instances.
 *
 * @see FlowModAddMatchFromValueCaseBuilder
 *
 */
public class FlowModAddMatchFromValueCaseBuilder implements Builder<FlowModAddMatchFromValueCase> {

    private FlowModAddMatchFromValue _flowModAddMatchFromValue;


    Map<Class<? extends Augmentation<FlowModAddMatchFromValueCase>>, Augmentation<FlowModAddMatchFromValueCase>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromValueCaseBuilder() {
    }

    public FlowModAddMatchFromValueCaseBuilder(FlowModAddMatchFromValueCase base) {
        this._flowModAddMatchFromValue = base.getFlowModAddMatchFromValue();
        if (base instanceof FlowModAddMatchFromValueCaseImpl) {
            FlowModAddMatchFromValueCaseImpl impl = (FlowModAddMatchFromValueCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModAddMatchFromValueCase>>, Augmentation<FlowModAddMatchFromValueCase>> aug =((AugmentationHolder<FlowModAddMatchFromValueCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public FlowModAddMatchFromValue getFlowModAddMatchFromValue() {
        return _flowModAddMatchFromValue;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModAddMatchFromValueCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModAddMatchFromValueCaseBuilder setFlowModAddMatchFromValue(final FlowModAddMatchFromValue value) {
        this._flowModAddMatchFromValue = value;
        return this;
    }
    
    public FlowModAddMatchFromValueCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValueCase>> augmentationType, Augmentation<FlowModAddMatchFromValueCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModAddMatchFromValueCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValueCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModAddMatchFromValueCase build() {
        return new FlowModAddMatchFromValueCaseImpl(this);
    }

    private static final class FlowModAddMatchFromValueCaseImpl implements FlowModAddMatchFromValueCase {
    
        private final FlowModAddMatchFromValue _flowModAddMatchFromValue;
    
        private Map<Class<? extends Augmentation<FlowModAddMatchFromValueCase>>, Augmentation<FlowModAddMatchFromValueCase>> augmentation = Collections.emptyMap();
    
        FlowModAddMatchFromValueCaseImpl(FlowModAddMatchFromValueCaseBuilder base) {
            this._flowModAddMatchFromValue = base.getFlowModAddMatchFromValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModAddMatchFromValueCase> getImplementedInterface() {
            return FlowModAddMatchFromValueCase.class;
        }
    
        @Override
        public FlowModAddMatchFromValue getFlowModAddMatchFromValue() {
            return _flowModAddMatchFromValue;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<FlowModAddMatchFromValueCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModAddMatchFromValue);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromValueCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModAddMatchFromValueCase other = (FlowModAddMatchFromValueCase)obj;
            if (!Objects.equals(_flowModAddMatchFromValue, other.getFlowModAddMatchFromValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromValueCaseImpl otherImpl = (FlowModAddMatchFromValueCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromValueCase>>, Augmentation<FlowModAddMatchFromValueCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromValueCase");
            CodeHelpers.appendValue(helper, "_flowModAddMatchFromValue", _flowModAddMatchFromValue);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
