package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.dst.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxCtTpDstBuilder} instances.
 *
 * @see NxmNxCtTpDstBuilder
 *
 */
public class NxmNxCtTpDstBuilder implements Builder<NxmNxCtTpDst> {

    private Integer _ctTpDst;
    private Integer _mask;


    Map<Class<? extends Augmentation<NxmNxCtTpDst>>, Augmentation<NxmNxCtTpDst>> augmentation = Collections.emptyMap();

    public NxmNxCtTpDstBuilder() {
    }

    public NxmNxCtTpDstBuilder(NxmNxCtTpDst base) {
        this._ctTpDst = base.getCtTpDst();
        this._mask = base.getMask();
        if (base instanceof NxmNxCtTpDstImpl) {
            NxmNxCtTpDstImpl impl = (NxmNxCtTpDstImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxCtTpDst>>, Augmentation<NxmNxCtTpDst>> aug =((AugmentationHolder<NxmNxCtTpDst>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Integer getCtTpDst() {
        return _ctTpDst;
    }
    
    public Integer getMask() {
        return _mask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmNxCtTpDst>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkCtTpDstRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxmNxCtTpDstBuilder setCtTpDst(final Integer value) {
    if (value != null) {
        checkCtTpDstRange(value);
        
    }
        this._ctTpDst = value;
        return this;
    }
    private static void checkMaskRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxmNxCtTpDstBuilder setMask(final Integer value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    
    public NxmNxCtTpDstBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtTpDst>> augmentationType, Augmentation<NxmNxCtTpDst> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxCtTpDstBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtTpDst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxCtTpDst build() {
        return new NxmNxCtTpDstImpl(this);
    }

    private static final class NxmNxCtTpDstImpl implements NxmNxCtTpDst {
    
        private final Integer _ctTpDst;
        private final Integer _mask;
    
        private Map<Class<? extends Augmentation<NxmNxCtTpDst>>, Augmentation<NxmNxCtTpDst>> augmentation = Collections.emptyMap();
    
        NxmNxCtTpDstImpl(NxmNxCtTpDstBuilder base) {
            this._ctTpDst = base.getCtTpDst();
            this._mask = base.getMask();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxCtTpDst> getImplementedInterface() {
            return NxmNxCtTpDst.class;
        }
    
        @Override
        public Integer getCtTpDst() {
            return _ctTpDst;
        }
        
        @Override
        public Integer getMask() {
            return _mask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmNxCtTpDst>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ctTpDst);
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtTpDst.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtTpDst other = (NxmNxCtTpDst)obj;
            if (!Objects.equals(_ctTpDst, other.getCtTpDst())) {
                return false;
            }
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxCtTpDstImpl otherImpl = (NxmNxCtTpDstImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtTpDst>>, Augmentation<NxmNxCtTpDst>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxCtTpDst");
            CodeHelpers.appendValue(helper, "_ctTpDst", _ctTpDst);
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
