/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match;

import com.google.common.base.Optional;
import org.opendaylight.openflowjava.nx.api.NiciraConstants;
import org.opendaylight.openflowplugin.extension.api.ConvertorFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorToOFJava;
import org.opendaylight.openflowplugin.extension.api.ExtensionAugment;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.api.path.MatchPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match.MatchUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.OfjAugNxExpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsh.ttl.grouping.NshTtlValues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsh.ttl.grouping.NshTtlValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.experimenter.id._case.NxExpMatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.experimenter.id._case.nx.exp.match.entry.value.NshTtlCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.experimenter.id._case.nx.exp.match.entry.value.NshTtlCaseValueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.ExtensionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.general.extension.grouping.Extension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNodesNodeTableFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNodesNodeTableFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketInBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshTtlKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.ttl.grouping.NxmNxNshTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.ttl.grouping.NxmNxNshTtlBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NshTtlConvertor
implements ConvertorToOFJava<MatchEntry>,
ConvertorFromOFJava<MatchEntry, MatchPath> {
    public ExtensionAugment<? extends Augmentation<Extension>> convert(MatchEntry input, MatchPath path) {
        ExperimenterIdCase experimenterIdCase = (ExperimenterIdCase)input.getMatchEntryValue();
        OfjAugNxExpMatch ofjAugNxExpMatch = (OfjAugNxExpMatch)experimenterIdCase.augmentation(OfjAugNxExpMatch.class);
        NshTtlCaseValue nshTtlCaseValue = (NshTtlCaseValue)ofjAugNxExpMatch.getNxExpMatchEntryValue();
        NxmNxNshTtl nxmNxNshTtl = new NxmNxNshTtlBuilder().setNshTtl(nshTtlCaseValue.getNshTtlValues().getNshTtl()).build();
        return NshTtlConvertor.resolveAugmentation(nxmNxNshTtl, path, NxmNxNshTtlKey.class);
    }

    public MatchEntry convert(Extension extension) {
        Optional matchGrouping = MatchUtil.NSH_TTL_RESOLVER.getExtension((Augmentable)extension);
        if (!matchGrouping.isPresent()) {
            throw new CodecPreconditionException(extension);
        }
        Short flags = ((NxmNxNshTtlGrouping)matchGrouping.get()).getNxmNxNshTtl().getNshTtl();
        return NshTtlConvertor.buildMatchEntry(flags, null);
    }

    public static MatchEntry buildMatchEntry(Short flags, Short mask) {
        NshTtlValues nshTtlValues = new NshTtlValuesBuilder().setNshTtl(flags).setMask(mask).build();
        NshTtlCaseValue value = new NshTtlCaseValueBuilder().setNshTtlValues(nshTtlValues).build();
        return MatchUtil.createExperimenterMatchEntryBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxNshTtl.class, NiciraConstants.NX_NSH_VENDOR_ID, (NxExpMatchEntryValue)value).setHasMask(Boolean.valueOf(mask != null)).build();
    }

    private static ExtensionAugment<? extends Augmentation<Extension>> resolveAugmentation(NxmNxNshTtl value, MatchPath path, Class<? extends ExtensionKey> key) {
        switch (path) {
            case FLOWS_STATISTICS_UPDATE_MATCH: {
                return new ExtensionAugment(NxAugMatchNodesNodeTableFlow.class, (Augmentation)new NxAugMatchNodesNodeTableFlowBuilder().setNxmNxNshTtl(value).build(), key);
            }
            case FLOWS_STATISTICS_RPC_MATCH: {
                return new ExtensionAugment(NxAugMatchRpcGetFlowStats.class, (Augmentation)new NxAugMatchRpcGetFlowStatsBuilder().setNxmNxNshTtl(value).build(), key);
            }
            case PACKET_RECEIVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifPacketIn.class, (Augmentation)new NxAugMatchNotifPacketInBuilder().setNxmNxNshTtl(value).build(), key);
            }
            case SWITCH_FLOW_REMOVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifSwitchFlowRemoved.class, (Augmentation)new NxAugMatchNotifSwitchFlowRemovedBuilder().setNxmNxNshTtl(value).build(), key);
            }
            case PACKET_IN_MESSAGE_MATCH: {
                return new ExtensionAugment(NxAugMatchPacketInMessage.class, (Augmentation)new NxAugMatchPacketInMessageBuilder().setNxmNxNshTtl(value).build(), key);
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }
}

