/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action;

import com.google.common.base.Preconditions;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionToOFJava;
import org.opendaylight.openflowplugin.extension.api.path.ActionPath;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action.ActionUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionEncap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionEncapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.encap.grouping.NxActionEncap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.encap.grouping.NxActionEncapBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionEncapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionEncapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionEncapNotifDirectStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action.NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionEncapNodesNodeTableFlowApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionEncapNodesNodeTableFlowWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncapBuilder;

public class EncapConvertor
implements ConvertorActionToOFJava<Action, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action>,
ConvertorActionFromOFJava<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action, ActionPath> {
    public Action convert(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action input, ActionPath path) {
        ActionEncap actionEncap = (ActionEncap)input.getActionChoice();
        Long packetType = actionEncap.getNxActionEncap().getPacketType();
        NxEncap nxEncap = new NxEncapBuilder().setPacketType(packetType).build();
        return EncapConvertor.resolveAction(nxEncap, path);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action convert(Action actionCase) {
        Preconditions.checkArgument((boolean)(actionCase instanceof NxActionEncapGrouping));
        NxActionEncapGrouping nxActionEncapGrouping = (NxActionEncapGrouping)actionCase;
        Long packetType = nxActionEncapGrouping.getNxEncap().getPacketType();
        NxActionEncap nxActionEncap = new NxActionEncapBuilder().setPacketType(packetType).build();
        ActionEncap actionEncap = new ActionEncapBuilder().setNxActionEncap(nxActionEncap).build();
        return ActionUtil.createAction((ActionChoice)actionEncap);
    }

    private static Action resolveAction(NxEncap value, ActionPath path) {
        switch (path) {
            case INVENTORY_FLOWNODE_TABLE_WRITE_ACTIONS: {
                return new NxActionEncapNodesNodeTableFlowWriteActionsCaseBuilder().setNxEncap(value).build();
            }
            case FLOWS_STATISTICS_UPDATE_WRITE_ACTIONS: {
                return new NxActionEncapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder().setNxEncap(value).build();
            }
            case FLOWS_STATISTICS_UPDATE_APPLY_ACTIONS: {
                return new NxActionEncapNotifFlowsStatisticsUpdateApplyActionsCaseBuilder().setNxEncap(value).build();
            }
            case GROUP_DESC_STATS_UPDATED_BUCKET_ACTION: {
                return new NxActionEncapNotifGroupDescStatsUpdatedCaseBuilder().setNxEncap(value).build();
            }
            case FLOWS_STATISTICS_RPC_WRITE_ACTIONS: {
                return new NxActionEncapNotifDirectStatisticsUpdateWriteActionsCaseBuilder().setNxEncap(value).build();
            }
            case FLOWS_STATISTICS_RPC_APPLY_ACTIONS: {
                return new NxActionEncapNotifDirectStatisticsUpdateApplyActionsCaseBuilder().setNxEncap(value).build();
            }
            case INVENTORY_FLOWNODE_TABLE_APPLY_ACTIONS: {
                return new NxActionEncapNodesNodeTableFlowApplyActionsCaseBuilder().setNxEncap(value).build();
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }
}

