package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxTunIdCaseBuilder} instances.
 *
 * @see SrcNxTunIdCaseBuilder
 *
 */
public class SrcNxTunIdCaseBuilder implements Builder<SrcNxTunIdCase> {

    private Boolean _nxTunId;


    Map<Class<? extends Augmentation<SrcNxTunIdCase>>, Augmentation<SrcNxTunIdCase>> augmentation = Collections.emptyMap();

    public SrcNxTunIdCaseBuilder() {
    }
    public SrcNxTunIdCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping arg) {
        this._nxTunId = arg.isNxTunId();
    }

    public SrcNxTunIdCaseBuilder(SrcNxTunIdCase base) {
        this._nxTunId = base.isNxTunId();
        if (base instanceof SrcNxTunIdCaseImpl) {
            SrcNxTunIdCaseImpl impl = (SrcNxTunIdCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxTunIdCase>>, Augmentation<SrcNxTunIdCase>> aug =((AugmentationHolder<SrcNxTunIdCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping) {
            this._nxTunId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping)arg).isNxTunId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIdGrouping]");
    }

    public Boolean isNxTunId() {
        return _nxTunId;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxTunIdCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxTunIdCaseBuilder setNxTunId(final Boolean value) {
        this._nxTunId = value;
        return this;
    }
    
    public SrcNxTunIdCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxTunIdCase>> augmentationType, Augmentation<SrcNxTunIdCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxTunIdCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxTunIdCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxTunIdCase build() {
        return new SrcNxTunIdCaseImpl(this);
    }

    private static final class SrcNxTunIdCaseImpl implements SrcNxTunIdCase {
    
        private final Boolean _nxTunId;
    
        private Map<Class<? extends Augmentation<SrcNxTunIdCase>>, Augmentation<SrcNxTunIdCase>> augmentation = Collections.emptyMap();
    
        SrcNxTunIdCaseImpl(SrcNxTunIdCaseBuilder base) {
            this._nxTunId = base.isNxTunId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxTunIdCase> getImplementedInterface() {
            return SrcNxTunIdCase.class;
        }
    
        @Override
        public Boolean isNxTunId() {
            return _nxTunId;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxTunIdCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxTunId);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxTunIdCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxTunIdCase other = (SrcNxTunIdCase)obj;
            if (!Objects.equals(_nxTunId, other.isNxTunId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxTunIdCaseImpl otherImpl = (SrcNxTunIdCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxTunIdCase>>, Augmentation<SrcNxTunIdCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxTunIdCase");
            CodeHelpers.appendValue(helper, "_nxTunId", _nxTunId);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
