package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.pkt.mark.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxPktMarkBuilder} instances.
 *
 * @see NxmNxPktMarkBuilder
 *
 */
public class NxmNxPktMarkBuilder implements Builder<NxmNxPktMark> {

    private Long _mask;
    private Long _pktMark;


    Map<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>> augmentation = Collections.emptyMap();

    public NxmNxPktMarkBuilder() {
    }

    public NxmNxPktMarkBuilder(NxmNxPktMark base) {
        this._mask = base.getMask();
        this._pktMark = base.getPktMark();
        if (base instanceof NxmNxPktMarkImpl) {
            NxmNxPktMarkImpl impl = (NxmNxPktMarkImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxmNxPktMark> casted =(AugmentationHolder<NxmNxPktMark>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Long getMask() {
        return _mask;
    }
    
    public Long getPktMark() {
        return _pktMark;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmNxPktMark>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaskRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxPktMarkBuilder setMask(final Long value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    private static void checkPktMarkRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxPktMarkBuilder setPktMark(final Long value) {
    if (value != null) {
        checkPktMarkRange(value);
        
    }
        this._pktMark = value;
        return this;
    }
    
    public NxmNxPktMarkBuilder addAugmentation(Class<? extends Augmentation<NxmNxPktMark>> augmentationType, Augmentation<NxmNxPktMark> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxPktMarkBuilder removeAugmentation(Class<? extends Augmentation<NxmNxPktMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxPktMark build() {
        return new NxmNxPktMarkImpl(this);
    }

    private static final class NxmNxPktMarkImpl implements NxmNxPktMark {
    
        private final Long _mask;
        private final Long _pktMark;
    
        private Map<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>> augmentation = Collections.emptyMap();
    
        private NxmNxPktMarkImpl(NxmNxPktMarkBuilder base) {
            this._mask = base.getMask();
            this._pktMark = base.getPktMark();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxPktMark> getImplementedInterface() {
            return NxmNxPktMark.class;
        }
    
        @Override
        public Long getMask() {
            return _mask;
        }
        
        @Override
        public Long getPktMark() {
            return _pktMark;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmNxPktMark>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(_pktMark);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxPktMark.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxPktMark other = (NxmNxPktMark)obj;
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(_pktMark, other.getPktMark())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxPktMarkImpl otherImpl = (NxmNxPktMarkImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxPktMark>>, Augmentation<NxmNxPktMark>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxPktMark");
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "_pktMark", _pktMark);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
