package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxCtStateBuilder} instances.
 *
 * @see NxmNxCtStateBuilder
 *
 */
public class NxmNxCtStateBuilder implements Builder<NxmNxCtState> {

    private Long _ctState;
    private Long _mask;


    Map<Class<? extends Augmentation<NxmNxCtState>>, Augmentation<NxmNxCtState>> augmentation = Collections.emptyMap();

    public NxmNxCtStateBuilder() {
    }

    public NxmNxCtStateBuilder(NxmNxCtState base) {
        this._ctState = base.getCtState();
        this._mask = base.getMask();
        if (base instanceof NxmNxCtStateImpl) {
            NxmNxCtStateImpl impl = (NxmNxCtStateImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxmNxCtState> casted =(AugmentationHolder<NxmNxCtState>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Long getCtState() {
        return _ctState;
    }
    
    public Long getMask() {
        return _mask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmNxCtState>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkCtStateRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxCtStateBuilder setCtState(final Long value) {
    if (value != null) {
        checkCtStateRange(value);
        
    }
        this._ctState = value;
        return this;
    }
    private static void checkMaskRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxCtStateBuilder setMask(final Long value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    
    public NxmNxCtStateBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtState>> augmentationType, Augmentation<NxmNxCtState> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxCtStateBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxCtState build() {
        return new NxmNxCtStateImpl(this);
    }

    private static final class NxmNxCtStateImpl implements NxmNxCtState {
    
        private final Long _ctState;
        private final Long _mask;
    
        private Map<Class<? extends Augmentation<NxmNxCtState>>, Augmentation<NxmNxCtState>> augmentation = Collections.emptyMap();
    
        private NxmNxCtStateImpl(NxmNxCtStateBuilder base) {
            this._ctState = base.getCtState();
            this._mask = base.getMask();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxCtState> getImplementedInterface() {
            return NxmNxCtState.class;
        }
    
        @Override
        public Long getCtState() {
            return _ctState;
        }
        
        @Override
        public Long getMask() {
            return _mask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmNxCtState>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ctState);
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtState.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtState other = (NxmNxCtState)obj;
            if (!Objects.equals(_ctState, other.getCtState())) {
                return false;
            }
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxCtStateImpl otherImpl = (NxmNxCtStateImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtState>>, Augmentation<NxmNxCtState>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxCtState");
            CodeHelpers.appendValue(helper, "_ctState", _ctState);
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
