package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.original.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.ct.clear.grouping.NxCtClear;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtClearRpcUpdateGroupOriginalCaseBuilder} instances.
 *
 * @see NxActionCtClearRpcUpdateGroupOriginalCaseBuilder
 *
 */
public class NxActionCtClearRpcUpdateGroupOriginalCaseBuilder implements Builder<NxActionCtClearRpcUpdateGroupOriginalCase> {

    private NxCtClear _nxCtClear;


    Map<Class<? extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>>, Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();

    public NxActionCtClearRpcUpdateGroupOriginalCaseBuilder() {
    }
    public NxActionCtClearRpcUpdateGroupOriginalCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping arg) {
        this._nxCtClear = arg.getNxCtClear();
    }

    public NxActionCtClearRpcUpdateGroupOriginalCaseBuilder(NxActionCtClearRpcUpdateGroupOriginalCase base) {
        this._nxCtClear = base.getNxCtClear();
        if (base instanceof NxActionCtClearRpcUpdateGroupOriginalCaseImpl) {
            NxActionCtClearRpcUpdateGroupOriginalCaseImpl impl = (NxActionCtClearRpcUpdateGroupOriginalCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionCtClearRpcUpdateGroupOriginalCase> casted =(AugmentationHolder<NxActionCtClearRpcUpdateGroupOriginalCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping) {
            this._nxCtClear = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping)arg).getNxCtClear();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping]");
    }

    public NxCtClear getNxCtClear() {
        return _nxCtClear;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionCtClearRpcUpdateGroupOriginalCaseBuilder setNxCtClear(final NxCtClear value) {
        this._nxCtClear = value;
        return this;
    }
    
    public NxActionCtClearRpcUpdateGroupOriginalCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> augmentationType, Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionCtClearRpcUpdateGroupOriginalCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtClearRpcUpdateGroupOriginalCase build() {
        return new NxActionCtClearRpcUpdateGroupOriginalCaseImpl(this);
    }

    private static final class NxActionCtClearRpcUpdateGroupOriginalCaseImpl implements NxActionCtClearRpcUpdateGroupOriginalCase {
    
        private final NxCtClear _nxCtClear;
    
        private Map<Class<? extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>>, Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();
    
        private NxActionCtClearRpcUpdateGroupOriginalCaseImpl(NxActionCtClearRpcUpdateGroupOriginalCaseBuilder base) {
            this._nxCtClear = base.getNxCtClear();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionCtClearRpcUpdateGroupOriginalCase> getImplementedInterface() {
            return NxActionCtClearRpcUpdateGroupOriginalCase.class;
        }
    
        @Override
        public NxCtClear getNxCtClear() {
            return _nxCtClear;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxCtClear);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtClearRpcUpdateGroupOriginalCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtClearRpcUpdateGroupOriginalCase other = (NxActionCtClearRpcUpdateGroupOriginalCase)obj;
            if (!Objects.equals(_nxCtClear, other.getNxCtClear())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionCtClearRpcUpdateGroupOriginalCaseImpl otherImpl = (NxActionCtClearRpcUpdateGroupOriginalCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>>, Augmentation<NxActionCtClearRpcUpdateGroupOriginalCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionCtClearRpcUpdateGroupOriginalCase");
            CodeHelpers.appendValue(helper, "_nxCtClear", _nxCtClear);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
