package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxOfMplsLabelCaseBuilder} instances.
 *
 * @see SrcNxOfMplsLabelCaseBuilder
 *
 */
public class SrcNxOfMplsLabelCaseBuilder implements Builder<SrcNxOfMplsLabelCase> {

    private Boolean _ofMplsLabel;


    Map<Class<? extends Augmentation<SrcNxOfMplsLabelCase>>, Augmentation<SrcNxOfMplsLabelCase>> augmentation = Collections.emptyMap();

    public SrcNxOfMplsLabelCaseBuilder() {
    }
    public SrcNxOfMplsLabelCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping arg) {
        this._ofMplsLabel = arg.isOfMplsLabel();
    }

    public SrcNxOfMplsLabelCaseBuilder(SrcNxOfMplsLabelCase base) {
        this._ofMplsLabel = base.isOfMplsLabel();
        if (base instanceof SrcNxOfMplsLabelCaseImpl) {
            SrcNxOfMplsLabelCaseImpl impl = (SrcNxOfMplsLabelCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<SrcNxOfMplsLabelCase> casted =(AugmentationHolder<SrcNxOfMplsLabelCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping) {
            this._ofMplsLabel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping)arg).isOfMplsLabel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping]");
    }

    public Boolean isOfMplsLabel() {
        return _ofMplsLabel;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxOfMplsLabelCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxOfMplsLabelCaseBuilder setOfMplsLabel(final Boolean value) {
        this._ofMplsLabel = value;
        return this;
    }
    
    public SrcNxOfMplsLabelCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxOfMplsLabelCase>> augmentationType, Augmentation<SrcNxOfMplsLabelCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxOfMplsLabelCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxOfMplsLabelCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxOfMplsLabelCase build() {
        return new SrcNxOfMplsLabelCaseImpl(this);
    }

    private static final class SrcNxOfMplsLabelCaseImpl implements SrcNxOfMplsLabelCase {
    
        private final Boolean _ofMplsLabel;
    
        private Map<Class<? extends Augmentation<SrcNxOfMplsLabelCase>>, Augmentation<SrcNxOfMplsLabelCase>> augmentation = Collections.emptyMap();
    
        private SrcNxOfMplsLabelCaseImpl(SrcNxOfMplsLabelCaseBuilder base) {
            this._ofMplsLabel = base.isOfMplsLabel();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxOfMplsLabelCase> getImplementedInterface() {
            return SrcNxOfMplsLabelCase.class;
        }
    
        @Override
        public Boolean isOfMplsLabel() {
            return _ofMplsLabel;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxOfMplsLabelCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofMplsLabel);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxOfMplsLabelCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxOfMplsLabelCase other = (SrcNxOfMplsLabelCase)obj;
            if (!Objects.equals(_ofMplsLabel, other.isOfMplsLabel())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxOfMplsLabelCaseImpl otherImpl = (SrcNxOfMplsLabelCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxOfMplsLabelCase>>, Augmentation<SrcNxOfMplsLabelCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxOfMplsLabelCase");
            CodeHelpers.appendValue(helper, "_ofMplsLabel", _ofMplsLabel);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
