package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxOfInPortCaseBuilder} instances.
 *
 * @see SrcNxOfInPortCaseBuilder
 *
 */
public class SrcNxOfInPortCaseBuilder implements Builder<SrcNxOfInPortCase> {

    private Boolean _ofInPort;


    Map<Class<? extends Augmentation<SrcNxOfInPortCase>>, Augmentation<SrcNxOfInPortCase>> augmentation = Collections.emptyMap();

    public SrcNxOfInPortCaseBuilder() {
    }
    public SrcNxOfInPortCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping arg) {
        this._ofInPort = arg.isOfInPort();
    }

    public SrcNxOfInPortCaseBuilder(SrcNxOfInPortCase base) {
        this._ofInPort = base.isOfInPort();
        if (base instanceof SrcNxOfInPortCaseImpl) {
            SrcNxOfInPortCaseImpl impl = (SrcNxOfInPortCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<SrcNxOfInPortCase> casted =(AugmentationHolder<SrcNxOfInPortCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping) {
            this._ofInPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping)arg).isOfInPort();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfInPortGrouping]");
    }

    public Boolean isOfInPort() {
        return _ofInPort;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxOfInPortCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxOfInPortCaseBuilder setOfInPort(final Boolean value) {
        this._ofInPort = value;
        return this;
    }
    
    public SrcNxOfInPortCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxOfInPortCase>> augmentationType, Augmentation<SrcNxOfInPortCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxOfInPortCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxOfInPortCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxOfInPortCase build() {
        return new SrcNxOfInPortCaseImpl(this);
    }

    private static final class SrcNxOfInPortCaseImpl implements SrcNxOfInPortCase {
    
        private final Boolean _ofInPort;
    
        private Map<Class<? extends Augmentation<SrcNxOfInPortCase>>, Augmentation<SrcNxOfInPortCase>> augmentation = Collections.emptyMap();
    
        private SrcNxOfInPortCaseImpl(SrcNxOfInPortCaseBuilder base) {
            this._ofInPort = base.isOfInPort();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxOfInPortCase> getImplementedInterface() {
            return SrcNxOfInPortCase.class;
        }
    
        @Override
        public Boolean isOfInPort() {
            return _ofInPort;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxOfInPortCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofInPort);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxOfInPortCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxOfInPortCase other = (SrcNxOfInPortCase)obj;
            if (!Objects.equals(_ofInPort, other.isOfInPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxOfInPortCaseImpl otherImpl = (SrcNxOfInPortCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxOfInPortCase>>, Augmentation<SrcNxOfInPortCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxOfInPortCase");
            CodeHelpers.appendValue(helper, "_ofInPort", _ofInPort);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
