package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxNshFlagsCaseBuilder} instances.
 *
 * @see SrcNxNshFlagsCaseBuilder
 *
 */
public class SrcNxNshFlagsCaseBuilder implements Builder<SrcNxNshFlagsCase> {

    private Boolean _nxNshFlags;


    Map<Class<? extends Augmentation<SrcNxNshFlagsCase>>, Augmentation<SrcNxNshFlagsCase>> augmentation = Collections.emptyMap();

    public SrcNxNshFlagsCaseBuilder() {
    }
    public SrcNxNshFlagsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping arg) {
        this._nxNshFlags = arg.isNxNshFlags();
    }

    public SrcNxNshFlagsCaseBuilder(SrcNxNshFlagsCase base) {
        this._nxNshFlags = base.isNxNshFlags();
        if (base instanceof SrcNxNshFlagsCaseImpl) {
            SrcNxNshFlagsCaseImpl impl = (SrcNxNshFlagsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<SrcNxNshFlagsCase> casted =(AugmentationHolder<SrcNxNshFlagsCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping) {
            this._nxNshFlags = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping)arg).isNxNshFlags();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping]");
    }

    public Boolean isNxNshFlags() {
        return _nxNshFlags;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxNshFlagsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNshFlagsCaseBuilder setNxNshFlags(final Boolean value) {
        this._nxNshFlags = value;
        return this;
    }
    
    public SrcNxNshFlagsCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNshFlagsCase>> augmentationType, Augmentation<SrcNxNshFlagsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNshFlagsCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshFlagsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshFlagsCase build() {
        return new SrcNxNshFlagsCaseImpl(this);
    }

    private static final class SrcNxNshFlagsCaseImpl implements SrcNxNshFlagsCase {
    
        private final Boolean _nxNshFlags;
    
        private Map<Class<? extends Augmentation<SrcNxNshFlagsCase>>, Augmentation<SrcNxNshFlagsCase>> augmentation = Collections.emptyMap();
    
        private SrcNxNshFlagsCaseImpl(SrcNxNshFlagsCaseBuilder base) {
            this._nxNshFlags = base.isNxNshFlags();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxNshFlagsCase> getImplementedInterface() {
            return SrcNxNshFlagsCase.class;
        }
    
        @Override
        public Boolean isNxNshFlags() {
            return _nxNshFlags;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxNshFlagsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshFlags);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNshFlagsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxNshFlagsCase other = (SrcNxNshFlagsCase)obj;
            if (!Objects.equals(_nxNshFlags, other.isNxNshFlags())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNshFlagsCaseImpl otherImpl = (SrcNxNshFlagsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNshFlagsCase>>, Augmentation<SrcNxNshFlagsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNshFlagsCase");
            CodeHelpers.appendValue(helper, "_nxNshFlags", _nxNshFlags);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
