package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionNatCaseBuilder} instances.
 *
 * @see NxActionNatCaseBuilder
 *
 */
public class NxActionNatCaseBuilder implements Builder<NxActionNatCase> {

    private NxActionNat _nxActionNat;


    Map<Class<? extends Augmentation<NxActionNatCase>>, Augmentation<NxActionNatCase>> augmentation = Collections.emptyMap();

    public NxActionNatCaseBuilder() {
    }

    public NxActionNatCaseBuilder(NxActionNatCase base) {
        this._nxActionNat = base.getNxActionNat();
        if (base instanceof NxActionNatCaseImpl) {
            NxActionNatCaseImpl impl = (NxActionNatCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionNatCase> casted =(AugmentationHolder<NxActionNatCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public NxActionNat getNxActionNat() {
        return _nxActionNat;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionNatCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionNatCaseBuilder setNxActionNat(final NxActionNat value) {
        this._nxActionNat = value;
        return this;
    }
    
    public NxActionNatCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionNatCase>> augmentationType, Augmentation<NxActionNatCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionNatCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionNatCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionNatCase build() {
        return new NxActionNatCaseImpl(this);
    }

    private static final class NxActionNatCaseImpl implements NxActionNatCase {
    
        private final NxActionNat _nxActionNat;
    
        private Map<Class<? extends Augmentation<NxActionNatCase>>, Augmentation<NxActionNatCase>> augmentation = Collections.emptyMap();
    
        private NxActionNatCaseImpl(NxActionNatCaseBuilder base) {
            this._nxActionNat = base.getNxActionNat();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionNatCase> getImplementedInterface() {
            return NxActionNatCase.class;
        }
    
        @Override
        public NxActionNat getNxActionNat() {
            return _nxActionNat;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionNatCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxActionNat);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionNatCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionNatCase other = (NxActionNatCase)obj;
            if (!Objects.equals(_nxActionNat, other.getNxActionNat())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionNatCaseImpl otherImpl = (NxActionNatCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionNatCase>>, Augmentation<NxActionNatCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionNatCase");
            CodeHelpers.appendValue(helper, "_nxActionNat", _nxActionNat);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
