package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcBuilder} instances.
 *
 * @see SrcBuilder
 *
 */
public class SrcBuilder implements Builder<Src> {

    private Integer _end;
    private SrcChoice _srcChoice;
    private Integer _start;


    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();

    public SrcBuilder() {
    }
    public SrcBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }
    public SrcBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public SrcBuilder(Src base) {
        this._end = base.getEnd();
        this._srcChoice = base.getSrcChoice();
        this._start = base.getStart();
        if (base instanceof SrcImpl) {
            SrcImpl impl = (SrcImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<Src> casted =(AugmentationHolder<Src>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping) {
            this._srcChoice = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping) {
            this._start = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping)arg).getStart();
            this._end = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping]");
    }

    public Integer getEnd() {
        return _end;
    }
    
    public SrcChoice getSrcChoice() {
        return _srcChoice;
    }
    
    public Integer getStart() {
        return _start;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<Src>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkEndRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public SrcBuilder setEnd(final Integer value) {
    if (value != null) {
        checkEndRange(value);
        
    }
        this._end = value;
        return this;
    }
    
    public SrcBuilder setSrcChoice(final SrcChoice value) {
        this._srcChoice = value;
        return this;
    }
    private static void checkStartRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public SrcBuilder setStart(final Integer value) {
    if (value != null) {
        checkStartRange(value);
        
    }
        this._start = value;
        return this;
    }
    
    public SrcBuilder addAugmentation(Class<? extends Augmentation<Src>> augmentationType, Augmentation<Src> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcBuilder removeAugmentation(Class<? extends Augmentation<Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl implements Src {
    
        private final Integer _end;
        private final SrcChoice _srcChoice;
        private final Integer _start;
    
        private Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();
    
        private SrcImpl(SrcBuilder base) {
            this._end = base.getEnd();
            this._srcChoice = base.getSrcChoice();
            this._start = base.getStart();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<Src> getImplementedInterface() {
            return Src.class;
        }
    
        @Override
        public Integer getEnd() {
            return _end;
        }
        
        @Override
        public SrcChoice getSrcChoice() {
            return _srcChoice;
        }
        
        @Override
        public Integer getStart() {
            return _start;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<Src>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_end);
            result = prime * result + Objects.hashCode(_srcChoice);
            result = prime * result + Objects.hashCode(_start);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Src.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Src other = (Src)obj;
            if (!Objects.equals(_end, other.getEnd())) {
                return false;
            }
            if (!Objects.equals(_srcChoice, other.getSrcChoice())) {
                return false;
            }
            if (!Objects.equals(_start, other.getStart())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcImpl otherImpl = (SrcImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Src");
            CodeHelpers.appendValue(helper, "_end", _end);
            CodeHelpers.appendValue(helper, "_srcChoice", _srcChoice);
            CodeHelpers.appendValue(helper, "_start", _start);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
