package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxDecapBuilder} instances.
 *
 * @see NxDecapBuilder
 *
 */
public class NxDecapBuilder implements Builder<NxDecap> {

    private Long _packetType;


    Map<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>> augmentation = Collections.emptyMap();

    public NxDecapBuilder() {
    }
    public NxDecapBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields arg) {
        this._packetType = arg.getPacketType();
    }

    public NxDecapBuilder(NxDecap base) {
        this._packetType = base.getPacketType();
        if (base instanceof NxDecapImpl) {
            NxDecapImpl impl = (NxDecapImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxDecap> casted =(AugmentationHolder<NxDecap>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields) {
            this._packetType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields)arg).getPacketType();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields]");
    }

    public Long getPacketType() {
        return _packetType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxDecap>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkPacketTypeRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxDecapBuilder setPacketType(final Long value) {
    if (value != null) {
        checkPacketTypeRange(value);
        
    }
        this._packetType = value;
        return this;
    }
    
    public NxDecapBuilder addAugmentation(Class<? extends Augmentation<NxDecap>> augmentationType, Augmentation<NxDecap> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxDecapBuilder removeAugmentation(Class<? extends Augmentation<NxDecap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxDecap build() {
        return new NxDecapImpl(this);
    }

    private static final class NxDecapImpl implements NxDecap {
    
        private final Long _packetType;
    
        private Map<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>> augmentation = Collections.emptyMap();
    
        private NxDecapImpl(NxDecapBuilder base) {
            this._packetType = base.getPacketType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxDecap> getImplementedInterface() {
            return NxDecap.class;
        }
    
        @Override
        public Long getPacketType() {
            return _packetType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxDecap>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_packetType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxDecap.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxDecap other = (NxDecap)obj;
            if (!Objects.equals(_packetType, other.getPacketType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxDecapImpl otherImpl = (NxDecapImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxDecap>>, Augmentation<NxDecap>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxDecap");
            CodeHelpers.appendValue(helper, "_packetType", _packetType);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
