package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder} instances.
 *
 * @see NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder
 *
 */
public class NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder implements Builder<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase> {

    private NxResubmit _nxResubmit;


    Map<Class<? extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>>, Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> augmentation = Collections.emptyMap();

    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder() {
    }
    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping arg) {
        this._nxResubmit = arg.getNxResubmit();
    }

    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder(NxActionResubmitNodesNodeGroupBucketsBucketActionsCase base) {
        this._nxResubmit = base.getNxResubmit();
        if (base instanceof NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl) {
            NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl impl = (NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase> casted =(AugmentationHolder<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping) {
            this._nxResubmit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping)arg).getNxResubmit();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping]");
    }

    public NxResubmit getNxResubmit() {
        return _nxResubmit;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder setNxResubmit(final NxResubmit value) {
        this._nxResubmit = value;
        return this;
    }
    
    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> augmentationType, Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionResubmitNodesNodeGroupBucketsBucketActionsCase build() {
        return new NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl(this);
    }

    private static final class NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl implements NxActionResubmitNodesNodeGroupBucketsBucketActionsCase {
    
        private final NxResubmit _nxResubmit;
    
        private Map<Class<? extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>>, Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> augmentation = Collections.emptyMap();
    
        private NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl(NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseBuilder base) {
            this._nxResubmit = base.getNxResubmit();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase> getImplementedInterface() {
            return NxActionResubmitNodesNodeGroupBucketsBucketActionsCase.class;
        }
    
        @Override
        public NxResubmit getNxResubmit() {
            return _nxResubmit;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxResubmit);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionResubmitNodesNodeGroupBucketsBucketActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionResubmitNodesNodeGroupBucketsBucketActionsCase other = (NxActionResubmitNodesNodeGroupBucketsBucketActionsCase)obj;
            if (!Objects.equals(_nxResubmit, other.getNxResubmit())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl otherImpl = (NxActionResubmitNodesNodeGroupBucketsBucketActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>>, Augmentation<NxActionResubmitNodesNodeGroupBucketsBucketActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionResubmitNodesNodeGroupBucketsBucketActionsCase");
            CodeHelpers.appendValue(helper, "_nxResubmit", _nxResubmit);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
