package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.field._case.FlowModAddMatchFromField;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModAddMatchFromFieldCaseBuilder} instances.
 *
 * @see FlowModAddMatchFromFieldCaseBuilder
 *
 */
public class FlowModAddMatchFromFieldCaseBuilder implements Builder<FlowModAddMatchFromFieldCase> {

    private FlowModAddMatchFromField _flowModAddMatchFromField;


    Map<Class<? extends Augmentation<FlowModAddMatchFromFieldCase>>, Augmentation<FlowModAddMatchFromFieldCase>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromFieldCaseBuilder() {
    }

    public FlowModAddMatchFromFieldCaseBuilder(FlowModAddMatchFromFieldCase base) {
        this._flowModAddMatchFromField = base.getFlowModAddMatchFromField();
        if (base instanceof FlowModAddMatchFromFieldCaseImpl) {
            FlowModAddMatchFromFieldCaseImpl impl = (FlowModAddMatchFromFieldCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<FlowModAddMatchFromFieldCase> casted =(AugmentationHolder<FlowModAddMatchFromFieldCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public FlowModAddMatchFromField getFlowModAddMatchFromField() {
        return _flowModAddMatchFromField;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<FlowModAddMatchFromFieldCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModAddMatchFromFieldCaseBuilder setFlowModAddMatchFromField(final FlowModAddMatchFromField value) {
        this._flowModAddMatchFromField = value;
        return this;
    }
    
    public FlowModAddMatchFromFieldCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromFieldCase>> augmentationType, Augmentation<FlowModAddMatchFromFieldCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModAddMatchFromFieldCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromFieldCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModAddMatchFromFieldCase build() {
        return new FlowModAddMatchFromFieldCaseImpl(this);
    }

    private static final class FlowModAddMatchFromFieldCaseImpl implements FlowModAddMatchFromFieldCase {
    
        private final FlowModAddMatchFromField _flowModAddMatchFromField;
    
        private Map<Class<? extends Augmentation<FlowModAddMatchFromFieldCase>>, Augmentation<FlowModAddMatchFromFieldCase>> augmentation = Collections.emptyMap();
    
        private FlowModAddMatchFromFieldCaseImpl(FlowModAddMatchFromFieldCaseBuilder base) {
            this._flowModAddMatchFromField = base.getFlowModAddMatchFromField();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlowModAddMatchFromFieldCase> getImplementedInterface() {
            return FlowModAddMatchFromFieldCase.class;
        }
    
        @Override
        public FlowModAddMatchFromField getFlowModAddMatchFromField() {
            return _flowModAddMatchFromField;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<FlowModAddMatchFromFieldCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModAddMatchFromField);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromFieldCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModAddMatchFromFieldCase other = (FlowModAddMatchFromFieldCase)obj;
            if (!Objects.equals(_flowModAddMatchFromField, other.getFlowModAddMatchFromField())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromFieldCaseImpl otherImpl = (FlowModAddMatchFromFieldCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromFieldCase>>, Augmentation<FlowModAddMatchFromFieldCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromFieldCase");
            CodeHelpers.appendValue(helper, "_flowModAddMatchFromField", _flowModAddMatchFromField);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
