package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstOfMetadataCaseBuilder} instances.
 *
 * @see DstOfMetadataCaseBuilder
 *
 */
public class DstOfMetadataCaseBuilder implements Builder<DstOfMetadataCase> {

    private Boolean _ofMetadata;


    Map<Class<? extends Augmentation<DstOfMetadataCase>>, Augmentation<DstOfMetadataCase>> augmentation = Collections.emptyMap();

    public DstOfMetadataCaseBuilder() {
    }
    public DstOfMetadataCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping arg) {
        this._ofMetadata = arg.isOfMetadata();
    }

    public DstOfMetadataCaseBuilder(DstOfMetadataCase base) {
        this._ofMetadata = base.isOfMetadata();
        if (base instanceof DstOfMetadataCaseImpl) {
            DstOfMetadataCaseImpl impl = (DstOfMetadataCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<DstOfMetadataCase> casted =(AugmentationHolder<DstOfMetadataCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping) {
            this._ofMetadata = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping)arg).isOfMetadata();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping]");
    }

    public Boolean isOfMetadata() {
        return _ofMetadata;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstOfMetadataCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfMetadataCaseBuilder setOfMetadata(final Boolean value) {
        this._ofMetadata = value;
        return this;
    }
    
    public DstOfMetadataCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfMetadataCase>> augmentationType, Augmentation<DstOfMetadataCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfMetadataCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfMetadataCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfMetadataCase build() {
        return new DstOfMetadataCaseImpl(this);
    }

    private static final class DstOfMetadataCaseImpl implements DstOfMetadataCase {
    
        private final Boolean _ofMetadata;
    
        private Map<Class<? extends Augmentation<DstOfMetadataCase>>, Augmentation<DstOfMetadataCase>> augmentation = Collections.emptyMap();
    
        private DstOfMetadataCaseImpl(DstOfMetadataCaseBuilder base) {
            this._ofMetadata = base.isOfMetadata();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstOfMetadataCase> getImplementedInterface() {
            return DstOfMetadataCase.class;
        }
    
        @Override
        public Boolean isOfMetadata() {
            return _ofMetadata;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstOfMetadataCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofMetadata);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfMetadataCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstOfMetadataCase other = (DstOfMetadataCase)obj;
            if (!Objects.equals(_ofMetadata, other.isOfMetadata())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfMetadataCaseImpl otherImpl = (DstOfMetadataCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfMetadataCase>>, Augmentation<DstOfMetadataCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfMetadataCase");
            CodeHelpers.appendValue(helper, "_ofMetadata", _ofMetadata);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
