package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstOfIpDstCaseBuilder} instances.
 *
 * @see DstOfIpDstCaseBuilder
 *
 */
public class DstOfIpDstCaseBuilder implements Builder<DstOfIpDstCase> {

    private Boolean _ofIpDst;


    Map<Class<? extends Augmentation<DstOfIpDstCase>>, Augmentation<DstOfIpDstCase>> augmentation = Collections.emptyMap();

    public DstOfIpDstCaseBuilder() {
    }
    public DstOfIpDstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpDstGrouping arg) {
        this._ofIpDst = arg.isOfIpDst();
    }

    public DstOfIpDstCaseBuilder(DstOfIpDstCase base) {
        this._ofIpDst = base.isOfIpDst();
        if (base instanceof DstOfIpDstCaseImpl) {
            DstOfIpDstCaseImpl impl = (DstOfIpDstCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<DstOfIpDstCase> casted =(AugmentationHolder<DstOfIpDstCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpDstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpDstGrouping) {
            this._ofIpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpDstGrouping)arg).isOfIpDst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIpDstGrouping]");
    }

    public Boolean isOfIpDst() {
        return _ofIpDst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstOfIpDstCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfIpDstCaseBuilder setOfIpDst(final Boolean value) {
        this._ofIpDst = value;
        return this;
    }
    
    public DstOfIpDstCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfIpDstCase>> augmentationType, Augmentation<DstOfIpDstCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfIpDstCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfIpDstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfIpDstCase build() {
        return new DstOfIpDstCaseImpl(this);
    }

    private static final class DstOfIpDstCaseImpl implements DstOfIpDstCase {
    
        private final Boolean _ofIpDst;
    
        private Map<Class<? extends Augmentation<DstOfIpDstCase>>, Augmentation<DstOfIpDstCase>> augmentation = Collections.emptyMap();
    
        private DstOfIpDstCaseImpl(DstOfIpDstCaseBuilder base) {
            this._ofIpDst = base.isOfIpDst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstOfIpDstCase> getImplementedInterface() {
            return DstOfIpDstCase.class;
        }
    
        @Override
        public Boolean isOfIpDst() {
            return _ofIpDst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstOfIpDstCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofIpDst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfIpDstCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstOfIpDstCase other = (DstOfIpDstCase)obj;
            if (!Objects.equals(_ofIpDst, other.isOfIpDst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfIpDstCaseImpl otherImpl = (DstOfIpDstCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfIpDstCase>>, Augmentation<DstOfIpDstCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfIpDstCase");
            CodeHelpers.appendValue(helper, "_ofIpDst", _ofIpDst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
