package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.add.group.input.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecapRpcAddGroupCaseBuilder} instances.
 *
 * @see NxActionDecapRpcAddGroupCaseBuilder
 *
 */
public class NxActionDecapRpcAddGroupCaseBuilder implements Builder<NxActionDecapRpcAddGroupCase> {

    private NxDecap _nxDecap;


    Map<Class<? extends Augmentation<NxActionDecapRpcAddGroupCase>>, Augmentation<NxActionDecapRpcAddGroupCase>> augmentation = Collections.emptyMap();

    public NxActionDecapRpcAddGroupCaseBuilder() {
    }
    public NxActionDecapRpcAddGroupCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping arg) {
        this._nxDecap = arg.getNxDecap();
    }

    public NxActionDecapRpcAddGroupCaseBuilder(NxActionDecapRpcAddGroupCase base) {
        this._nxDecap = base.getNxDecap();
        if (base instanceof NxActionDecapRpcAddGroupCaseImpl) {
            NxActionDecapRpcAddGroupCaseImpl impl = (NxActionDecapRpcAddGroupCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionDecapRpcAddGroupCase> casted =(AugmentationHolder<NxActionDecapRpcAddGroupCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping) {
            this._nxDecap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping)arg).getNxDecap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping]");
    }

    public NxDecap getNxDecap() {
        return _nxDecap;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionDecapRpcAddGroupCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionDecapRpcAddGroupCaseBuilder setNxDecap(final NxDecap value) {
        this._nxDecap = value;
        return this;
    }
    
    public NxActionDecapRpcAddGroupCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecapRpcAddGroupCase>> augmentationType, Augmentation<NxActionDecapRpcAddGroupCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionDecapRpcAddGroupCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecapRpcAddGroupCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecapRpcAddGroupCase build() {
        return new NxActionDecapRpcAddGroupCaseImpl(this);
    }

    private static final class NxActionDecapRpcAddGroupCaseImpl implements NxActionDecapRpcAddGroupCase {
    
        private final NxDecap _nxDecap;
    
        private Map<Class<? extends Augmentation<NxActionDecapRpcAddGroupCase>>, Augmentation<NxActionDecapRpcAddGroupCase>> augmentation = Collections.emptyMap();
    
        private NxActionDecapRpcAddGroupCaseImpl(NxActionDecapRpcAddGroupCaseBuilder base) {
            this._nxDecap = base.getNxDecap();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionDecapRpcAddGroupCase> getImplementedInterface() {
            return NxActionDecapRpcAddGroupCase.class;
        }
    
        @Override
        public NxDecap getNxDecap() {
            return _nxDecap;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionDecapRpcAddGroupCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecap);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecapRpcAddGroupCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionDecapRpcAddGroupCase other = (NxActionDecapRpcAddGroupCase)obj;
            if (!Objects.equals(_nxDecap, other.getNxDecap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecapRpcAddGroupCaseImpl otherImpl = (NxActionDecapRpcAddGroupCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecapRpcAddGroupCase>>, Augmentation<NxActionDecapRpcAddGroupCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecapRpcAddGroupCase");
            CodeHelpers.appendValue(helper, "_nxDecap", _nxDecap);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
