package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.add.group.input.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionConntrackRpcAddGroupCaseBuilder} instances.
 *
 * @see NxActionConntrackRpcAddGroupCaseBuilder
 *
 */
public class NxActionConntrackRpcAddGroupCaseBuilder implements Builder<NxActionConntrackRpcAddGroupCase> {

    private NxConntrack _nxConntrack;


    Map<Class<? extends Augmentation<NxActionConntrackRpcAddGroupCase>>, Augmentation<NxActionConntrackRpcAddGroupCase>> augmentation = Collections.emptyMap();

    public NxActionConntrackRpcAddGroupCaseBuilder() {
    }
    public NxActionConntrackRpcAddGroupCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping arg) {
        this._nxConntrack = arg.getNxConntrack();
    }

    public NxActionConntrackRpcAddGroupCaseBuilder(NxActionConntrackRpcAddGroupCase base) {
        this._nxConntrack = base.getNxConntrack();
        if (base instanceof NxActionConntrackRpcAddGroupCaseImpl) {
            NxActionConntrackRpcAddGroupCaseImpl impl = (NxActionConntrackRpcAddGroupCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<NxActionConntrackRpcAddGroupCase> casted =(AugmentationHolder<NxActionConntrackRpcAddGroupCase>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping) {
            this._nxConntrack = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping)arg).getNxConntrack();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping]");
    }

    public NxConntrack getNxConntrack() {
        return _nxConntrack;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionConntrackRpcAddGroupCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionConntrackRpcAddGroupCaseBuilder setNxConntrack(final NxConntrack value) {
        this._nxConntrack = value;
        return this;
    }
    
    public NxActionConntrackRpcAddGroupCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionConntrackRpcAddGroupCase>> augmentationType, Augmentation<NxActionConntrackRpcAddGroupCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionConntrackRpcAddGroupCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionConntrackRpcAddGroupCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionConntrackRpcAddGroupCase build() {
        return new NxActionConntrackRpcAddGroupCaseImpl(this);
    }

    private static final class NxActionConntrackRpcAddGroupCaseImpl implements NxActionConntrackRpcAddGroupCase {
    
        private final NxConntrack _nxConntrack;
    
        private Map<Class<? extends Augmentation<NxActionConntrackRpcAddGroupCase>>, Augmentation<NxActionConntrackRpcAddGroupCase>> augmentation = Collections.emptyMap();
    
        private NxActionConntrackRpcAddGroupCaseImpl(NxActionConntrackRpcAddGroupCaseBuilder base) {
            this._nxConntrack = base.getNxConntrack();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionConntrackRpcAddGroupCase> getImplementedInterface() {
            return NxActionConntrackRpcAddGroupCase.class;
        }
    
        @Override
        public NxConntrack getNxConntrack() {
            return _nxConntrack;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionConntrackRpcAddGroupCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxConntrack);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionConntrackRpcAddGroupCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionConntrackRpcAddGroupCase other = (NxActionConntrackRpcAddGroupCase)obj;
            if (!Objects.equals(_nxConntrack, other.getNxConntrack())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionConntrackRpcAddGroupCaseImpl otherImpl = (NxActionConntrackRpcAddGroupCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionConntrackRpcAddGroupCase>>, Augmentation<NxActionConntrackRpcAddGroupCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionConntrackRpcAddGroupCase");
            CodeHelpers.appendValue(helper, "_nxConntrack", _nxConntrack);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
