/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match;

import com.google.common.base.Optional;
import org.opendaylight.openflowplugin.extension.api.ConvertorFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorToOFJava;
import org.opendaylight.openflowplugin.extension.api.ExtensionAugment;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.api.path.MatchPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match.MatchUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxCtTpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.ct.tp.dst.grouping.CtTpDstValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.CtTpDstCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.CtTpDstCaseValueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.ExtensionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.general.extension.grouping.Extension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNodesNodeTableFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNodesNodeTableFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketInBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtTpDstKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.dst.grouping.NxmNxCtTpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.dst.grouping.NxmNxCtTpDstBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class CtTpDstConvertor
implements ConvertorToOFJava<MatchEntry>,
ConvertorFromOFJava<MatchEntry, MatchPath> {
    public MatchEntry convert(Extension extension) {
        Optional matchGrouping = MatchUtil.CT_TP_DST_RESOLVER.getExtension((Augmentable)extension);
        if (!matchGrouping.isPresent()) {
            throw new CodecPreconditionException(extension);
        }
        CtTpDstCaseValueBuilder ctTpDstCaseValueBuilder = new CtTpDstCaseValueBuilder();
        CtTpDstValuesBuilder ctTpDstValuesBuilder = new CtTpDstValuesBuilder();
        ctTpDstValuesBuilder.setCtTpDst(((NxmNxCtTpDstGrouping)matchGrouping.get()).getNxmNxCtTpDst().getCtTpDst());
        ctTpDstCaseValueBuilder.setCtTpDstValues(ctTpDstValuesBuilder.build());
        MatchEntryBuilder ofMatch = MatchUtil.createDefaultMatchEntryBuilder(NxmNxCtTpSrc.class, Nxm1Class.class, (MatchEntryValue)ctTpDstCaseValueBuilder.build());
        return ofMatch.build();
    }

    public ExtensionAugment<? extends Augmentation<Extension>> convert(MatchEntry input, MatchPath path) {
        CtTpDstCaseValue ctTpSrcCaseValue = (CtTpDstCaseValue)input.getMatchEntryValue();
        NxmNxCtTpDstBuilder ctTpSrcBuilder = new NxmNxCtTpDstBuilder();
        ctTpSrcBuilder.setCtTpDst(ctTpSrcCaseValue.getCtTpDstValues().getCtTpDst());
        return CtTpDstConvertor.resolveAugmentation(ctTpSrcBuilder.build(), path, NxmNxCtTpDstKey.class);
    }

    private static ExtensionAugment<? extends Augmentation<Extension>> resolveAugmentation(NxmNxCtTpDst value, MatchPath path, Class<? extends ExtensionKey> key) {
        switch (path) {
            case FLOWS_STATISTICS_UPDATE_MATCH: {
                return new ExtensionAugment(NxAugMatchNodesNodeTableFlow.class, (Augmentation)new NxAugMatchNodesNodeTableFlowBuilder().setNxmNxCtTpDst(value).build(), key);
            }
            case FLOWS_STATISTICS_RPC_MATCH: {
                return new ExtensionAugment(NxAugMatchRpcGetFlowStats.class, (Augmentation)new NxAugMatchRpcGetFlowStatsBuilder().setNxmNxCtTpDst(value).build(), key);
            }
            case PACKET_RECEIVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifPacketIn.class, (Augmentation)new NxAugMatchNotifPacketInBuilder().setNxmNxCtTpDst(value).build(), key);
            }
            case SWITCH_FLOW_REMOVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifSwitchFlowRemoved.class, (Augmentation)new NxAugMatchNotifSwitchFlowRemovedBuilder().setNxmNxCtTpDst(value).build(), key);
            }
            case PACKET_IN_MESSAGE_MATCH: {
                return new ExtensionAugment(NxAugMatchPacketInMessage.class, (Augmentation)new NxAugMatchPacketInMessageBuilder().setNxmNxCtTpDst(value).build(), key);
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }
}

