/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.mark.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.mark.grouping.NxmNxCtMark;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxCtMarkBuilder
implements Builder<NxmNxCtMark> {
    private Long _ctMark;
    private Long _mask;
    Map<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> augmentation = Collections.emptyMap();

    public NxmNxCtMarkBuilder() {
    }

    public NxmNxCtMarkBuilder(NxmNxCtMark base) {
        AugmentationHolder casted;
        this._ctMark = base.getCtMark();
        this._mask = base.getMask();
        if (base instanceof NxmNxCtMarkImpl) {
            NxmNxCtMarkImpl impl = (NxmNxCtMarkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>>(casted.augmentations());
        }
    }

    public Long getCtMark() {
        return this._ctMark;
    }

    public Long getMask() {
        return this._mask;
    }

    public <E extends Augmentation<NxmNxCtMark>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCtMarkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public NxmNxCtMarkBuilder setCtMark(Long value) {
        if (value != null) {
            NxmNxCtMarkBuilder.checkCtMarkRange(value);
        }
        this._ctMark = value;
        return this;
    }

    private static void checkMaskRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public NxmNxCtMarkBuilder setMask(Long value) {
        if (value != null) {
            NxmNxCtMarkBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public NxmNxCtMarkBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtMark>> augmentationType, Augmentation<NxmNxCtMark> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxCtMarkBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxCtMark build() {
        return new NxmNxCtMarkImpl(this);
    }

    private static final class NxmNxCtMarkImpl
    implements NxmNxCtMark {
        private final Long _ctMark;
        private final Long _mask;
        private Map<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxmNxCtMark> getImplementedInterface() {
            return NxmNxCtMark.class;
        }

        private NxmNxCtMarkImpl(NxmNxCtMarkBuilder base) {
            this._ctMark = base.getCtMark();
            this._mask = base.getMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getCtMark() {
            return this._ctMark;
        }

        @Override
        public Long getMask() {
            return this._mask;
        }

        public <E extends Augmentation<NxmNxCtMark>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ctMark);
            result = 31 * result + Objects.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtMark.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtMark other = (NxmNxCtMark)obj;
            if (!Objects.equals(this._ctMark, other.getCtMark())) {
                return false;
            }
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxCtMarkImpl otherImpl = (NxmNxCtMarkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtMark>>, Augmentation<NxmNxCtMark>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxmNxCtMark [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ctMark != null) {
                builder.append("_ctMark=");
                builder.append(this._ctMark);
                builder.append(", ");
            }
            if (this._mask != null) {
                builder.append("_mask=");
                builder.append(this._mask);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

