package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-match</b>
 * <pre>
 * grouping all-matches-grouping {
 *     container nxm-nx-reg {
 *         leaf reg {
 *             type identityref;
 *         }
 *         leaf value {
 *             type uint32;
 *         }
 *         leaf mask {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-tun-id {
 *         leaf value {
 *             type uint64;
 *         }
 *     }
 *     container nxm-nx-arp-sha {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-nx-arp-tha {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-of-arp-op {
 *         leaf value {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-arp-spa {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-arp-tpa {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container of-in-port {
 *         leaf value {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-tun-ipv4-dst {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-nx-tun-ipv4-src {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-eth-src {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-of-eth-dst {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-of-eth-type {
 *         leaf value {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-nsp {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-nsi {
 *         leaf nsi {
 *             type uint8;
 *         }
 *     }
 *     container nxm-nx-nshc-1 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-nshc-2 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-nshc-3 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-nshc-4 {
 *         leaf value {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-encap-eth-type {
 *         leaf value {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-encap-eth-src {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-nx-encap-eth-dst {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 *     container nxm-nx-nsh-mdtype {
 *         leaf value {
 *             type uint8;
 *         }
 *     }
 *     container nxm-nx-nsh-np {
 *         leaf value {
 *             type uint8;
 *         }
 *     }
 *     container nxm-nx-tun-gpe-np {
 *         leaf value {
 *             type uint8;
 *         }
 *     }
 *     container nxm-of-tcp-src {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-tcp-dst {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-udp-src {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-udp-dst {
 *         leaf port {
 *             type port-number;
 *         }
 *         leaf mask {
 *             type uint16;
 *         }
 *     }
 *     container nxm-nx-ct-state {
 *         leaf ct-state {
 *             type uint32;
 *         }
 *         leaf mask {
 *             type uint32;
 *         }
 *     }
 *     container nxm-nx-ct-zone {
 *         leaf ct-zone {
 *             type uint16;
 *         }
 *     }
 *     container nxm-of-ip-dst {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-ip-src {
 *         leaf ipv4-address {
 *             type ipv4-address;
 *         }
 *         uses ipv4-address-grouping;
 *     }
 *     container nxm-of-icmp-type {
 *         leaf value {
 *             type uint8;
 *         }
 *     }
 *     container nxm-nx-ct-mark {
 *         leaf ct-mark {
 *             type uint32;
 *         }
 *         leaf mask {
 *             type uint32;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-match/all-matches-grouping</i>
 *
 */
public interface AllMatchesGrouping
    extends
    DataObject,
    NxmNxCtZoneGrouping,
    NxmOfTcpSrcGrouping,
    NxmNxNshNpGrouping,
    NxmOfEthDstGrouping,
    NxmNxEncapEthDstGrouping,
    NxmNxNshc4Grouping,
    NxmNxTunIdGrouping,
    NxmNxTunGpeNpGrouping,
    NxmOfUdpDstGrouping,
    NxmNxRegGrouping,
    NxmOfInPortGrouping,
    NxmNxCtMarkGrouping,
    NxmOfEthTypeGrouping,
    NxmNxNspGrouping,
    NxmNxNshc2Grouping,
    NxmOfIpDstGrouping,
    NxmNxCtStateGrouping,
    NxmNxTunIpv4SrcGrouping,
    NxmOfUdpSrcGrouping,
    NxmNxArpThaGrouping,
    NxmNxTunIpv4DstGrouping,
    NxmNxNsiGrouping,
    NxmOfEthSrcGrouping,
    NxmNxEncapEthSrcGrouping,
    NxmOfTcpDstGrouping,
    NxmNxNshc3Grouping,
    NxmOfIpSrcGrouping,
    NxmOfArpSpaGrouping,
    NxmNxArpShaGrouping,
    NxmNxNshc1Grouping,
    NxmNxEncapEthTypeGrouping,
    NxmOfIcmpTypeGrouping,
    NxmOfArpOpGrouping,
    NxmOfArpTpaGrouping,
    NxmNxNshMdtypeGrouping
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:match",
        "2014-07-14", "all-matches-grouping").intern();


}

