/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match;

import com.google.common.base.Optional;
import org.opendaylight.openflowplugin.extension.api.ConvertorFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorToOFJava;
import org.opendaylight.openflowplugin.extension.api.ExtensionAugment;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.api.path.MatchPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.match.MatchUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxNsi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsi.grouping.NsiValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.NsiCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.NsiCaseValueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.ExtensionKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.general.rev140714.general.extension.grouping.Extension;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNodesNodeTableFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNodesNodeTableFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifPacketInBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchNotifSwitchFlowRemovedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchPacketInMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcGetFlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping.NxmNxNsiBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NsiConvertor
implements ConvertorToOFJava<MatchEntry>,
ConvertorFromOFJava<MatchEntry, MatchPath> {
    public ExtensionAugment<? extends Augmentation<Extension>> convert(MatchEntry input, MatchPath path) {
        NsiCaseValue nsiCaseValue = (NsiCaseValue)input.getMatchEntryValue();
        return NsiConvertor.resolveAugmentation(new NxmNxNsiBuilder().setNsi(nsiCaseValue.getNsiValues().getNsi()).build(), path, NxmNxNsiKey.class);
    }

    public MatchEntry convert(Extension extension) {
        Optional matchGrouping = MatchUtil.NSI_RESOLVER.getExtension((Augmentable)extension);
        if (!matchGrouping.isPresent()) {
            throw new CodecPreconditionException(extension);
        }
        Short value = ((NxmNxNsiGrouping)matchGrouping.get()).getNxmNxNsi().getNsi();
        NsiCaseValueBuilder nsiCaseValueBuilder = new NsiCaseValueBuilder();
        nsiCaseValueBuilder.setNsiValues(new NsiValuesBuilder().setNsi(value).build());
        return MatchUtil.createDefaultMatchEntryBuilder(NxmNxNsi.class, Nxm1Class.class, (MatchEntryValue)nsiCaseValueBuilder.build()).build();
    }

    private static ExtensionAugment<? extends Augmentation<Extension>> resolveAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping.NxmNxNsi value, MatchPath path, Class<? extends ExtensionKey> key) {
        switch (path) {
            case FLOWS_STATISTICS_UPDATE_MATCH: {
                return new ExtensionAugment(NxAugMatchNodesNodeTableFlow.class, (Augmentation)new NxAugMatchNodesNodeTableFlowBuilder().setNxmNxNsi(value).build(), key);
            }
            case FLOWS_STATISTICS_RPC_MATCH: {
                return new ExtensionAugment(NxAugMatchRpcGetFlowStats.class, (Augmentation)new NxAugMatchRpcGetFlowStatsBuilder().setNxmNxNsi(value).build(), key);
            }
            case PACKET_RECEIVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifPacketIn.class, (Augmentation)new NxAugMatchNotifPacketInBuilder().setNxmNxNsi(value).build(), key);
            }
            case SWITCH_FLOW_REMOVED_MATCH: {
                return new ExtensionAugment(NxAugMatchNotifSwitchFlowRemoved.class, (Augmentation)new NxAugMatchNotifSwitchFlowRemovedBuilder().setNxmNxNsi(value).build(), key);
            }
            case PACKET_IN_MESSAGE_MATCH: {
                return new ExtensionAugment(NxAugMatchPacketInMessage.class, (Augmentation)new NxAugMatchPacketInMessageBuilder().setNxmNxNsi(value).build(), key);
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }
}

