/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionNatBuilder
implements Builder<NxActionNat> {
    private Integer _flags;
    private IpAddress _ipAddressMax;
    private IpAddress _ipAddressMin;
    private Integer _portMax;
    private Integer _portMin;
    private Integer _rangePresent;
    Map<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> augmentation = Collections.emptyMap();

    public NxActionNatBuilder() {
    }

    public NxActionNatBuilder(NxActionNat base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        this._ipAddressMax = base.getIpAddressMax();
        this._ipAddressMin = base.getIpAddressMin();
        this._portMax = base.getPortMax();
        this._portMin = base.getPortMin();
        this._rangePresent = base.getRangePresent();
        if (base instanceof NxActionNatImpl) {
            NxActionNatImpl impl = (NxActionNatImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>>(casted.augmentations());
        }
    }

    public Integer getFlags() {
        return this._flags;
    }

    public IpAddress getIpAddressMax() {
        return this._ipAddressMax;
    }

    public IpAddress getIpAddressMin() {
        return this._ipAddressMin;
    }

    public Integer getPortMax() {
        return this._portMax;
    }

    public Integer getPortMin() {
        return this._portMin;
    }

    public Integer getRangePresent() {
        return this._rangePresent;
    }

    public <E extends Augmentation<NxActionNat>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkFlagsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxActionNatBuilder setFlags(Integer value) {
        if (value != null) {
            NxActionNatBuilder.checkFlagsRange(value);
        }
        this._flags = value;
        return this;
    }

    public NxActionNatBuilder setIpAddressMax(IpAddress value) {
        this._ipAddressMax = value;
        return this;
    }

    public NxActionNatBuilder setIpAddressMin(IpAddress value) {
        this._ipAddressMin = value;
        return this;
    }

    private static void checkPortMaxRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxActionNatBuilder setPortMax(Integer value) {
        if (value != null) {
            NxActionNatBuilder.checkPortMaxRange(value);
        }
        this._portMax = value;
        return this;
    }

    private static void checkPortMinRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxActionNatBuilder setPortMin(Integer value) {
        if (value != null) {
            NxActionNatBuilder.checkPortMinRange(value);
        }
        this._portMin = value;
        return this;
    }

    private static void checkRangePresentRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxActionNatBuilder setRangePresent(Integer value) {
        if (value != null) {
            NxActionNatBuilder.checkRangePresentRange(value);
        }
        this._rangePresent = value;
        return this;
    }

    public NxActionNatBuilder addAugmentation(Class<? extends Augmentation<NxActionNat>> augmentationType, Augmentation<NxActionNat> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxActionNatBuilder removeAugmentation(Class<? extends Augmentation<NxActionNat>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionNat build() {
        return new NxActionNatImpl(this);
    }

    private static final class NxActionNatImpl
    implements NxActionNat {
        private final Integer _flags;
        private final IpAddress _ipAddressMax;
        private final IpAddress _ipAddressMin;
        private final Integer _portMax;
        private final Integer _portMin;
        private final Integer _rangePresent;
        private Map<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionNat> getImplementedInterface() {
            return NxActionNat.class;
        }

        private NxActionNatImpl(NxActionNatBuilder base) {
            this._flags = base.getFlags();
            this._ipAddressMax = base.getIpAddressMax();
            this._ipAddressMin = base.getIpAddressMin();
            this._portMax = base.getPortMax();
            this._portMin = base.getPortMin();
            this._rangePresent = base.getRangePresent();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getFlags() {
            return this._flags;
        }

        @Override
        public IpAddress getIpAddressMax() {
            return this._ipAddressMax;
        }

        @Override
        public IpAddress getIpAddressMin() {
            return this._ipAddressMin;
        }

        @Override
        public Integer getPortMax() {
            return this._portMax;
        }

        @Override
        public Integer getPortMin() {
            return this._portMin;
        }

        @Override
        public Integer getRangePresent() {
            return this._rangePresent;
        }

        public <E extends Augmentation<NxActionNat>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._ipAddressMax);
            result = 31 * result + Objects.hashCode(this._ipAddressMin);
            result = 31 * result + Objects.hashCode(this._portMax);
            result = 31 * result + Objects.hashCode(this._portMin);
            result = 31 * result + Objects.hashCode(this._rangePresent);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionNat.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionNat other = (NxActionNat)obj;
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._ipAddressMax, other.getIpAddressMax())) {
                return false;
            }
            if (!Objects.equals(this._ipAddressMin, other.getIpAddressMin())) {
                return false;
            }
            if (!Objects.equals(this._portMax, other.getPortMax())) {
                return false;
            }
            if (!Objects.equals(this._portMin, other.getPortMin())) {
                return false;
            }
            if (!Objects.equals(this._rangePresent, other.getRangePresent())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionNatImpl otherImpl = (NxActionNatImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxActionNat [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._ipAddressMax != null) {
                builder.append("_ipAddressMax=");
                builder.append(this._ipAddressMax);
                builder.append(", ");
            }
            if (this._ipAddressMin != null) {
                builder.append("_ipAddressMin=");
                builder.append(this._ipAddressMin);
                builder.append(", ");
            }
            if (this._portMax != null) {
                builder.append("_portMax=");
                builder.append(this._portMax);
                builder.append(", ");
            }
            if (this._portMin != null) {
                builder.append("_portMin=");
                builder.append(this._portMin);
                builder.append(", ");
            }
            if (this._rangePresent != null) {
                builder.append("_rangePresent=");
                builder.append(this._rangePresent);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

