package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * grouping nx-action-conntrack-grouping {
 *     container nx-conntrack {
 *         leaf flags {
 *             type uint16;
 *         }
 *         leaf zone-src {
 *             type uint32;
 *         }
 *         leaf conntrack-zone {
 *             type uint16;
 *         }
 *         leaf recirc-table {
 *             type uint8;
 *         }
 *         list ct-actions {
 *             key     choice ofpact-actions {
 *                 case nx-action-nat-case {
 *                     container nx-action-nat {
 *                         leaf flags {
 *                             type uint16;
 *                         }
 *                         leaf range_present {
 *                             type uint16;
 *                         }
 *                         leaf ip-address-min {
 *                             type ip-address;
 *                         }
 *                         leaf ip-address-max {
 *                             type ip-address;
 *                         }
 *                         leaf port-min {
 *                             type uint16;
 *                         }
 *                         leaf port-max {
 *                             type uint16;
 *                         }
 *                     }
 *                 }
 *             }
 *             uses ofpact-actions;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping</i>
 *
 */
public interface NxActionConntrackGrouping
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-action-conntrack-grouping").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack</code> <code>nxConntrack</code>, or <code>null</code> if not present
     */
    NxConntrack getNxConntrack();

}

