/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

public class NxConntrackBuilder
implements Builder<NxConntrack> {
    private Uint16 _conntrackZone;
    private List<CtActions> _ctActions;
    private Uint16 _flags;
    private Uint8 _recircTable;
    private Uint32 _zoneSrc;
    Map<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> augmentation = Collections.emptyMap();

    public NxConntrackBuilder() {
    }

    public NxConntrackBuilder(NxConntrack base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>(aug);
        }
        this._conntrackZone = base.getConntrackZone();
        this._ctActions = base.getCtActions();
        this._flags = base.getFlags();
        this._recircTable = base.getRecircTable();
        this._zoneSrc = base.getZoneSrc();
    }

    public Uint16 getConntrackZone() {
        return this._conntrackZone;
    }

    public List<CtActions> getCtActions() {
        return this._ctActions;
    }

    public Uint16 getFlags() {
        return this._flags;
    }

    public Uint8 getRecircTable() {
        return this._recircTable;
    }

    public Uint32 getZoneSrc() {
        return this._zoneSrc;
    }

    public <E$$ extends Augmentation<NxConntrack>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NxConntrackBuilder setConntrackZone(Uint16 value) {
        this._conntrackZone = value;
        return this;
    }

    public NxConntrackBuilder setCtActions(List<CtActions> values) {
        this._ctActions = values;
        return this;
    }

    public NxConntrackBuilder setFlags(Uint16 value) {
        this._flags = value;
        return this;
    }

    public NxConntrackBuilder setRecircTable(Uint8 value) {
        this._recircTable = value;
        return this;
    }

    public NxConntrackBuilder setZoneSrc(Uint32 value) {
        this._zoneSrc = value;
        return this;
    }

    public NxConntrackBuilder addAugmentation(Augmentation<NxConntrack> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxConntrackBuilder removeAugmentation(Class<? extends Augmentation<NxConntrack>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxConntrack build() {
        return new NxConntrackImpl(this);
    }

    private static final class NxConntrackImpl
    extends AbstractAugmentable<NxConntrack>
    implements NxConntrack {
        private final Uint16 _conntrackZone;
        private final List<CtActions> _ctActions;
        private final Uint16 _flags;
        private final Uint8 _recircTable;
        private final Uint32 _zoneSrc;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxConntrackImpl(NxConntrackBuilder base) {
            super(base.augmentation);
            this._conntrackZone = base.getConntrackZone();
            this._ctActions = CodeHelpers.emptyToNull(base.getCtActions());
            this._flags = base.getFlags();
            this._recircTable = base.getRecircTable();
            this._zoneSrc = base.getZoneSrc();
        }

        @Override
        public Uint16 getConntrackZone() {
            return this._conntrackZone;
        }

        @Override
        public List<CtActions> getCtActions() {
            return this._ctActions;
        }

        @Override
        public Uint16 getFlags() {
            return this._flags;
        }

        @Override
        public Uint8 getRecircTable() {
            return this._recircTable;
        }

        @Override
        public Uint32 getZoneSrc() {
            return this._zoneSrc;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NxConntrack.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NxConntrack.bindingEquals(this, obj);
        }

        public String toString() {
            return NxConntrack.bindingToString(this);
        }
    }
}

