package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-match</b>
 * <pre>
 * container nxm-nx-ct-state {
 *   leaf ct-state {
 *     type uint32;
 *   }
 *   leaf mask {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-matchnxm-nx-ct-state-groupingnxm-nx-ct-state</i>
 *
 * <p>To create instances of this class use {@link NxmNxCtStateBuilder}.
 * @see NxmNxCtStateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxmNxCtState
    extends
    ChildOf<NxmNxCtStateGrouping>,
    Augmentable<NxmNxCtState>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nxm-nx-ct-state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.NxmNxCtState> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.NxmNxCtState.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.@NonNull NxmNxCtState obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getCtState());
        result = prime * result + Objects.hashCode(obj.getMask());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.@NonNull NxmNxCtState thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.NxmNxCtState other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.NxmNxCtState.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getCtState(), other.getCtState())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMask(), other.getMask())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.@NonNull NxmNxCtState obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxCtState");
        CodeHelpers.appendValue(helper, "ctState", obj.getCtState());
        CodeHelpers.appendValue(helper, "mask", obj.getMask());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return ctState, or {@code null} if it is not present.
     *
     * @return {@code Uint32} ctState, or {@code null} if it is not present.
     *
     */
    Uint32 getCtState();
    
    /**
     * Return ctState, guaranteed to be non-null.
     *
     * @return {@code Uint32} ctState, guaranteed to be non-null.
     * @throws NoSuchElementException if ctState is not present
     *
     */
    default @NonNull Uint32 requireCtState() {
        return CodeHelpers.require(getCtState(), "ctstate");
    }
    
    /**
     * Return mask, or {@code null} if it is not present.
     *
     * @return {@code Uint32} mask, or {@code null} if it is not present.
     *
     */
    Uint32 getMask();
    
    /**
     * Return mask, guaranteed to be non-null.
     *
     * @return {@code Uint32} mask, guaranteed to be non-null.
     * @throws NoSuchElementException if mask is not present
     *
     */
    default @NonNull Uint32 requireMask() {
        return CodeHelpers.require(getMask(), "mask");
    }

}

