package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.original.group.buckets.bucket.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionMultipathRpcUpdateGroupOriginalCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionMultipathRpcUpdateGroupOriginalCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionMultipathRpcUpdateGroupOriginalCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionMultipathRpcUpdateGroupOriginalCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionMultipathRpcUpdateGroupOriginalCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionMultipathRpcUpdateGroupOriginalCaseBuilder implements Builder<NxActionMultipathRpcUpdateGroupOriginalCase> {

    private NxMultipath _nxMultipath;


    Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>>, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();

    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder() {
    }
    
    
    
    
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder(NxActionMultipathGrouping arg) {
        this._nxMultipath = arg.getNxMultipath();
    }

    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder(NxActionMultipathRpcUpdateGroupOriginalCase base) {
        Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>>, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxMultipath = base.getNxMultipath();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NxActionMultipathGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NxActionMultipathGrouping) {
            this._nxMultipath = ((NxActionMultipathGrouping)arg).getNxMultipath();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NxActionMultipathGrouping]");
    }

    public NxMultipath getNxMultipath() {
        return _nxMultipath;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder setNxMultipath(final NxMultipath value) {
        this._nxMultipath = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder addAugmentation(Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase> augmentation) {
        Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionMultipathRpcUpdateGroupOriginalCase build() {
        return new NxActionMultipathRpcUpdateGroupOriginalCaseImpl(this);
    }

    private static final class NxActionMultipathRpcUpdateGroupOriginalCaseImpl
        extends AbstractAugmentable<NxActionMultipathRpcUpdateGroupOriginalCase>
        implements NxActionMultipathRpcUpdateGroupOriginalCase {
    
        private final NxMultipath _nxMultipath;
    
        NxActionMultipathRpcUpdateGroupOriginalCaseImpl(NxActionMultipathRpcUpdateGroupOriginalCaseBuilder base) {
            super(base.augmentation);
            this._nxMultipath = base.getNxMultipath();
        }
    
        @Override
        public NxMultipath getNxMultipath() {
            return _nxMultipath;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionMultipathRpcUpdateGroupOriginalCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionMultipathRpcUpdateGroupOriginalCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionMultipathRpcUpdateGroupOriginalCase.bindingToString(this);
        }
    }
}
