package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.original.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder implements Builder<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase> {

    private NxDecap _nxDecap;


    Map<Class<? extends Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder() {
    }
    
    
    
    
    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder(NxActionDecapGrouping arg) {
        this._nxDecap = arg.getNxDecap();
    }

    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder(NxActionDecapRpcUpdateFlowOriginalWriteActionsCase base) {
        Map<Class<? extends Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxDecap = base.getNxDecap();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NxActionDecapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NxActionDecapGrouping) {
            this._nxDecap = ((NxActionDecapGrouping)arg).getNxDecap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NxActionDecapGrouping]");
    }

    public NxDecap getNxDecap() {
        return _nxDecap;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder setNxDecap(final NxDecap value) {
        this._nxDecap = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder addAugmentation(Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase> augmentation) {
        Class<? extends Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecapRpcUpdateFlowOriginalWriteActionsCase build() {
        return new NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseImpl(this);
    }

    private static final class NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionDecapRpcUpdateFlowOriginalWriteActionsCase>
        implements NxActionDecapRpcUpdateFlowOriginalWriteActionsCase {
    
        private final NxDecap _nxDecap;
    
        NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseImpl(NxActionDecapRpcUpdateFlowOriginalWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxDecap = base.getNxDecap();
        }
    
        @Override
        public NxDecap getNxDecap() {
            return _nxDecap;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionDecapRpcUpdateFlowOriginalWriteActionsCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionDecapRpcUpdateFlowOriginalWriteActionsCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionDecapRpcUpdateFlowOriginalWriteActionsCase.bindingToString(this);
        }
    }
}
