package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.transmit.packet.input.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionResubmitRpcTransmitPacketCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionResubmitRpcTransmitPacketCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionResubmitRpcTransmitPacketCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionResubmitRpcTransmitPacketCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionResubmitRpcTransmitPacketCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionResubmitRpcTransmitPacketCaseBuilder implements Builder<NxActionResubmitRpcTransmitPacketCase> {

    private NxResubmit _nxResubmit;


    Map<Class<? extends Augmentation<NxActionResubmitRpcTransmitPacketCase>>, Augmentation<NxActionResubmitRpcTransmitPacketCase>> augmentation = Collections.emptyMap();

    public NxActionResubmitRpcTransmitPacketCaseBuilder() {
    }
    
    
    
    
    public NxActionResubmitRpcTransmitPacketCaseBuilder(NxActionResubmitGrouping arg) {
        this._nxResubmit = arg.getNxResubmit();
    }

    public NxActionResubmitRpcTransmitPacketCaseBuilder(NxActionResubmitRpcTransmitPacketCase base) {
        Map<Class<? extends Augmentation<NxActionResubmitRpcTransmitPacketCase>>, Augmentation<NxActionResubmitRpcTransmitPacketCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxResubmit = base.getNxResubmit();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NxActionResubmitGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NxActionResubmitGrouping) {
            this._nxResubmit = ((NxActionResubmitGrouping)arg).getNxResubmit();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NxActionResubmitGrouping]");
    }

    public NxResubmit getNxResubmit() {
        return _nxResubmit;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionResubmitRpcTransmitPacketCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionResubmitRpcTransmitPacketCaseBuilder setNxResubmit(final NxResubmit value) {
        this._nxResubmit = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionResubmitRpcTransmitPacketCaseBuilder addAugmentation(Augmentation<NxActionResubmitRpcTransmitPacketCase> augmentation) {
        Class<? extends Augmentation<NxActionResubmitRpcTransmitPacketCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionResubmitRpcTransmitPacketCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionResubmitRpcTransmitPacketCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionResubmitRpcTransmitPacketCase build() {
        return new NxActionResubmitRpcTransmitPacketCaseImpl(this);
    }

    private static final class NxActionResubmitRpcTransmitPacketCaseImpl
        extends AbstractAugmentable<NxActionResubmitRpcTransmitPacketCase>
        implements NxActionResubmitRpcTransmitPacketCase {
    
        private final NxResubmit _nxResubmit;
    
        NxActionResubmitRpcTransmitPacketCaseImpl(NxActionResubmitRpcTransmitPacketCaseBuilder base) {
            super(base.augmentation);
            this._nxResubmit = base.getNxResubmit();
        }
    
        @Override
        public NxResubmit getNxResubmit() {
            return _nxResubmit;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionResubmitRpcTransmitPacketCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionResubmitRpcTransmitPacketCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionResubmitRpcTransmitPacketCase.bindingToString(this);
        }
    }
}
