package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link NxMultipathBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxMultipathBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxMultipathBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxMultipathBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxMultipathBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxMultipathBuilder implements Builder<NxMultipath> {

    private OfjNxMpAlgorithm _algorithm;
    private Uint32 _arg;
    private Uint16 _basis;
    private Dst _dst;
    private OfjNxHashFields _fields;
    private Uint16 _maxLink;


    Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> augmentation = Collections.emptyMap();

    public NxMultipathBuilder() {
    }
    
    

    public NxMultipathBuilder(NxMultipath base) {
        Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._algorithm = base.getAlgorithm();
        this._arg = base.getArg();
        this._basis = base.getBasis();
        this._dst = base.getDst();
        this._fields = base.getFields();
        this._maxLink = base.getMaxLink();
    }


    public OfjNxMpAlgorithm getAlgorithm() {
        return _algorithm;
    }
    
    public Uint32 getArg() {
        return _arg;
    }
    
    public Uint16 getBasis() {
        return _basis;
    }
    
    public Dst getDst() {
        return _dst;
    }
    
    public OfjNxHashFields getFields() {
        return _fields;
    }
    
    public Uint16 getMaxLink() {
        return _maxLink;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxMultipath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxMultipathBuilder setAlgorithm(final OfjNxMpAlgorithm value) {
        this._algorithm = value;
        return this;
    }
    
    public NxMultipathBuilder setArg(final Uint32 value) {
        this._arg = value;
        return this;
    }
    
    public NxMultipathBuilder setBasis(final Uint16 value) {
        this._basis = value;
        return this;
    }
    
    public NxMultipathBuilder setDst(final Dst value) {
        this._dst = value;
        return this;
    }
    
    public NxMultipathBuilder setFields(final OfjNxHashFields value) {
        this._fields = value;
        return this;
    }
    
    public NxMultipathBuilder setMaxLink(final Uint16 value) {
        this._maxLink = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxMultipathBuilder addAugmentation(Augmentation<NxMultipath> augmentation) {
        Class<? extends Augmentation<NxMultipath>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxMultipathBuilder removeAugmentation(Class<? extends Augmentation<NxMultipath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxMultipath build() {
        return new NxMultipathImpl(this);
    }

    private static final class NxMultipathImpl
        extends AbstractAugmentable<NxMultipath>
        implements NxMultipath {
    
        private final OfjNxMpAlgorithm _algorithm;
        private final Uint32 _arg;
        private final Uint16 _basis;
        private final Dst _dst;
        private final OfjNxHashFields _fields;
        private final Uint16 _maxLink;
    
        NxMultipathImpl(NxMultipathBuilder base) {
            super(base.augmentation);
            this._algorithm = base.getAlgorithm();
            this._arg = base.getArg();
            this._basis = base.getBasis();
            this._dst = base.getDst();
            this._fields = base.getFields();
            this._maxLink = base.getMaxLink();
        }
    
        @Override
        public OfjNxMpAlgorithm getAlgorithm() {
            return _algorithm;
        }
        
        @Override
        public Uint32 getArg() {
            return _arg;
        }
        
        @Override
        public Uint16 getBasis() {
            return _basis;
        }
        
        @Override
        public Dst getDst() {
            return _dst;
        }
        
        @Override
        public OfjNxHashFields getFields() {
            return _fields;
        }
        
        @Override
        public Uint16 getMaxLink() {
            return _maxLink;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxMultipath.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxMultipath.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxMultipath.bindingToString(this);
        }
    }
}
