package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstOfMetadataCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DstOfMetadataCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DstOfMetadataCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DstOfMetadataCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DstOfMetadataCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class DstOfMetadataCaseBuilder implements Builder<DstOfMetadataCase> {

    private Empty _ofMetadata;


    Map<Class<? extends Augmentation<DstOfMetadataCase>>, Augmentation<DstOfMetadataCase>> augmentation = Collections.emptyMap();

    public DstOfMetadataCaseBuilder() {
    }
    
    
    
    
    public DstOfMetadataCaseBuilder(OxmOfMetadataGrouping arg) {
        this._ofMetadata = arg.getOfMetadata();
    }

    public DstOfMetadataCaseBuilder(DstOfMetadataCase base) {
        Map<Class<? extends Augmentation<DstOfMetadataCase>>, Augmentation<DstOfMetadataCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ofMetadata = base.getOfMetadata();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>OxmOfMetadataGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OxmOfMetadataGrouping) {
            this._ofMetadata = ((OxmOfMetadataGrouping)arg).getOfMetadata();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OxmOfMetadataGrouping]");
    }

    public Empty getOfMetadata() {
        return _ofMetadata;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstOfMetadataCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public DstOfMetadataCaseBuilder setOfMetadata(final Empty value) {
        this._ofMetadata = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DstOfMetadataCaseBuilder addAugmentation(Augmentation<DstOfMetadataCase> augmentation) {
        Class<? extends Augmentation<DstOfMetadataCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DstOfMetadataCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfMetadataCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfMetadataCase build() {
        return new DstOfMetadataCaseImpl(this);
    }

    private static final class DstOfMetadataCaseImpl
        extends AbstractAugmentable<DstOfMetadataCase>
        implements DstOfMetadataCase {
    
        private final Empty _ofMetadata;
    
        DstOfMetadataCaseImpl(DstOfMetadataCaseBuilder base) {
            super(base.augmentation);
            this._ofMetadata = base.getOfMetadata();
        }
    
        @Override
        public Empty getOfMetadata() {
            return _ofMetadata;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = DstOfMetadataCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return DstOfMetadataCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return DstOfMetadataCase.bindingToString(this);
        }
    }
}
