package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link NxEncapBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxEncapBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxEncapBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxEncapBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxEncapBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxEncapBuilder implements Builder<NxEncap> {

    private Uint32 _packetType;


    Map<Class<? extends Augmentation<NxEncap>>, Augmentation<NxEncap>> augmentation = Collections.emptyMap();

    public NxEncapBuilder() {
    }
    
    
    
    public NxEncapBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields arg) {
        this._packetType = arg.getPacketType();
    }

    public NxEncapBuilder(NxEncap base) {
        Map<Class<? extends Augmentation<NxEncap>>, Augmentation<NxEncap>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._packetType = base.getPacketType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields) {
            this._packetType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields)arg).getPacketType();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.PacketTypeFields]");
    }

    public Uint32 getPacketType() {
        return _packetType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxEncap>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxEncapBuilder setPacketType(final Uint32 value) {
        this._packetType = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setPacketType(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxEncapBuilder setPacketType(final Long value) {
        return setPacketType(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxEncapBuilder addAugmentation(Augmentation<NxEncap> augmentation) {
        Class<? extends Augmentation<NxEncap>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxEncapBuilder removeAugmentation(Class<? extends Augmentation<NxEncap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxEncap build() {
        return new NxEncapImpl(this);
    }

    private static final class NxEncapImpl
        extends AbstractAugmentable<NxEncap>
        implements NxEncap {
    
        private final Uint32 _packetType;
    
        NxEncapImpl(NxEncapBuilder base) {
            super(base.augmentation);
            this._packetType = base.getPacketType();
        }
    
        @Override
        public Uint32 getPacketType() {
            return _packetType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxEncap.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxEncap.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxEncap.bindingToString(this);
        }
    }
}
