package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link FlowModOutputToPortBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModOutputToPortBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModOutputToPortBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModOutputToPortBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModOutputToPortBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class FlowModOutputToPortBuilder implements Builder<FlowModOutputToPort> {

    private Uint16 _flowModNumBits;
    private Uint32 _srcField;
    private Uint16 _srcOfs;


    Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> augmentation = Collections.emptyMap();

    public FlowModOutputToPortBuilder() {
    }
    
    

    public FlowModOutputToPortBuilder(FlowModOutputToPort base) {
        Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
    }


    public Uint16 getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Uint32 getSrcField() {
        return _srcField;
    }
    
    public Uint16 getSrcOfs() {
        return _srcOfs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModOutputToPort>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public FlowModOutputToPortBuilder setFlowModNumBits(final Uint16 value) {
        this._flowModNumBits = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setFlowModNumBits(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModOutputToPortBuilder setFlowModNumBits(final Integer value) {
        return setFlowModNumBits(CodeHelpers.compatUint(value));
    }
    
    public FlowModOutputToPortBuilder setSrcField(final Uint32 value) {
        this._srcField = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setSrcField(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModOutputToPortBuilder setSrcField(final Long value) {
        return setSrcField(CodeHelpers.compatUint(value));
    }
    
    public FlowModOutputToPortBuilder setSrcOfs(final Uint16 value) {
        this._srcOfs = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setSrcOfs(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModOutputToPortBuilder setSrcOfs(final Integer value) {
        return setSrcOfs(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public FlowModOutputToPortBuilder addAugmentation(Augmentation<FlowModOutputToPort> augmentation) {
        Class<? extends Augmentation<FlowModOutputToPort>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public FlowModOutputToPortBuilder removeAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModOutputToPort build() {
        return new FlowModOutputToPortImpl(this);
    }

    private static final class FlowModOutputToPortImpl
        extends AbstractAugmentable<FlowModOutputToPort>
        implements FlowModOutputToPort {
    
        private final Uint16 _flowModNumBits;
        private final Uint32 _srcField;
        private final Uint16 _srcOfs;
    
        FlowModOutputToPortImpl(FlowModOutputToPortBuilder base) {
            super(base.augmentation);
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
        }
    
        @Override
        public Uint16 getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Uint32 getSrcField() {
            return _srcField;
        }
        
        @Override
        public Uint16 getSrcOfs() {
            return _srcOfs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = FlowModOutputToPort.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return FlowModOutputToPort.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return FlowModOutputToPort.bindingToString(this);
        }
    }
}
