package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxTunIpv4DstCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcNxTunIpv4DstCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcNxTunIpv4DstCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcNxTunIpv4DstCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcNxTunIpv4DstCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SrcNxTunIpv4DstCaseBuilder implements Builder<SrcNxTunIpv4DstCase> {

    private Empty _nxTunIpv4Dst;


    Map<Class<? extends Augmentation<SrcNxTunIpv4DstCase>>, Augmentation<SrcNxTunIpv4DstCase>> augmentation = Collections.emptyMap();

    public SrcNxTunIpv4DstCaseBuilder() {
    }
    
    
    
    public SrcNxTunIpv4DstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping arg) {
        this._nxTunIpv4Dst = arg.getNxTunIpv4Dst();
    }
    

    public SrcNxTunIpv4DstCaseBuilder(SrcNxTunIpv4DstCase base) {
        Map<Class<? extends Augmentation<SrcNxTunIpv4DstCase>>, Augmentation<SrcNxTunIpv4DstCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxTunIpv4Dst = base.getNxTunIpv4Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping) {
            this._nxTunIpv4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping)arg).getNxTunIpv4Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping]");
    }

    public Empty getNxTunIpv4Dst() {
        return _nxTunIpv4Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxTunIpv4DstCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrcNxTunIpv4DstCaseBuilder setNxTunIpv4Dst(final Empty value) {
        this._nxTunIpv4Dst = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrcNxTunIpv4DstCaseBuilder addAugmentation(Augmentation<SrcNxTunIpv4DstCase> augmentation) {
        Class<? extends Augmentation<SrcNxTunIpv4DstCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrcNxTunIpv4DstCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxTunIpv4DstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxTunIpv4DstCase build() {
        return new SrcNxTunIpv4DstCaseImpl(this);
    }

    private static final class SrcNxTunIpv4DstCaseImpl
        extends AbstractAugmentable<SrcNxTunIpv4DstCase>
        implements SrcNxTunIpv4DstCase {
    
        private final Empty _nxTunIpv4Dst;
    
        SrcNxTunIpv4DstCaseImpl(SrcNxTunIpv4DstCaseBuilder base) {
            super(base.augmentation);
            this._nxTunIpv4Dst = base.getNxTunIpv4Dst();
        }
    
        @Override
        public Empty getNxTunIpv4Dst() {
            return _nxTunIpv4Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SrcNxTunIpv4DstCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SrcNxTunIpv4DstCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SrcNxTunIpv4DstCase.bindingToString(this);
        }
    }
}
