package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcNxNshc2CaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SrcNxNshc2CaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SrcNxNshc2CaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SrcNxNshc2CaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SrcNxNshc2CaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SrcNxNshc2CaseBuilder implements Builder<SrcNxNshc2Case> {

    private Empty _nxNshc2Dst;


    Map<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> augmentation = Collections.emptyMap();

    public SrcNxNshc2CaseBuilder() {
    }
    
    
    
    public SrcNxNshc2CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping arg) {
        this._nxNshc2Dst = arg.getNxNshc2Dst();
    }
    

    public SrcNxNshc2CaseBuilder(SrcNxNshc2Case base) {
        Map<Class<? extends Augmentation<SrcNxNshc2Case>>, Augmentation<SrcNxNshc2Case>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxNshc2Dst = base.getNxNshc2Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping) {
            this._nxNshc2Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping)arg).getNxNshc2Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping]");
    }

    public Empty getNxNshc2Dst() {
        return _nxNshc2Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNshc2Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public SrcNxNshc2CaseBuilder setNxNshc2Dst(final Empty value) {
        this._nxNshc2Dst = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SrcNxNshc2CaseBuilder addAugmentation(Augmentation<SrcNxNshc2Case> augmentation) {
        Class<? extends Augmentation<SrcNxNshc2Case>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SrcNxNshc2CaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshc2Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshc2Case build() {
        return new SrcNxNshc2CaseImpl(this);
    }

    private static final class SrcNxNshc2CaseImpl
        extends AbstractAugmentable<SrcNxNshc2Case>
        implements SrcNxNshc2Case {
    
        private final Empty _nxNshc2Dst;
    
        SrcNxNshc2CaseImpl(SrcNxNshc2CaseBuilder base) {
            super(base.augmentation);
            this._nxNshc2Dst = base.getNxNshc2Dst();
        }
    
        @Override
        public Empty getNxNshc2Dst() {
            return _nxNshc2Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SrcNxNshc2Case.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SrcNxNshc2Case.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SrcNxNshc2Case.bindingToString(this);
        }
    }
}
