/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

public class NxMultipathBuilder
implements Builder<NxMultipath> {
    private OfjNxMpAlgorithm _algorithm;
    private Uint32 _arg;
    private Uint16 _basis;
    private Dst _dst;
    private OfjNxHashFields _fields;
    private Uint16 _maxLink;
    Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> augmentation = Collections.emptyMap();

    public NxMultipathBuilder() {
    }

    public NxMultipathBuilder(NxMultipath base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>(aug);
        }
        this._algorithm = base.getAlgorithm();
        this._arg = base.getArg();
        this._basis = base.getBasis();
        this._dst = base.getDst();
        this._fields = base.getFields();
        this._maxLink = base.getMaxLink();
    }

    public OfjNxMpAlgorithm getAlgorithm() {
        return this._algorithm;
    }

    public Uint32 getArg() {
        return this._arg;
    }

    public Uint16 getBasis() {
        return this._basis;
    }

    public Dst getDst() {
        return this._dst;
    }

    public OfjNxHashFields getFields() {
        return this._fields;
    }

    public Uint16 getMaxLink() {
        return this._maxLink;
    }

    public <E$$ extends Augmentation<NxMultipath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NxMultipathBuilder setAlgorithm(OfjNxMpAlgorithm value) {
        this._algorithm = value;
        return this;
    }

    public NxMultipathBuilder setArg(Uint32 value) {
        this._arg = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NxMultipathBuilder setArg(Long value) {
        return this.setArg(CodeHelpers.compatUint((Long)value));
    }

    public NxMultipathBuilder setBasis(Uint16 value) {
        this._basis = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NxMultipathBuilder setBasis(Integer value) {
        return this.setBasis(CodeHelpers.compatUint((Integer)value));
    }

    public NxMultipathBuilder setDst(Dst value) {
        this._dst = value;
        return this;
    }

    public NxMultipathBuilder setFields(OfjNxHashFields value) {
        this._fields = value;
        return this;
    }

    public NxMultipathBuilder setMaxLink(Uint16 value) {
        this._maxLink = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NxMultipathBuilder setMaxLink(Integer value) {
        return this.setMaxLink(CodeHelpers.compatUint((Integer)value));
    }

    public NxMultipathBuilder addAugmentation(Augmentation<NxMultipath> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxMultipathBuilder removeAugmentation(Class<? extends Augmentation<NxMultipath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxMultipath build() {
        return new NxMultipathImpl(this);
    }

    private static final class NxMultipathImpl
    extends AbstractAugmentable<NxMultipath>
    implements NxMultipath {
        private final OfjNxMpAlgorithm _algorithm;
        private final Uint32 _arg;
        private final Uint16 _basis;
        private final Dst _dst;
        private final OfjNxHashFields _fields;
        private final Uint16 _maxLink;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxMultipathImpl(NxMultipathBuilder base) {
            super(base.augmentation);
            this._algorithm = base.getAlgorithm();
            this._arg = base.getArg();
            this._basis = base.getBasis();
            this._dst = base.getDst();
            this._fields = base.getFields();
            this._maxLink = base.getMaxLink();
        }

        @Override
        public OfjNxMpAlgorithm getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public Uint32 getArg() {
            return this._arg;
        }

        @Override
        public Uint16 getBasis() {
            return this._basis;
        }

        @Override
        public Dst getDst() {
            return this._dst;
        }

        @Override
        public OfjNxHashFields getFields() {
            return this._fields;
        }

        @Override
        public Uint16 getMaxLink() {
            return this._maxLink;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NxMultipath.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NxMultipath.bindingEquals(this, obj);
        }

        public String toString() {
            return NxMultipath.bindingToString(this);
        }
    }
}

