package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.nx.learn.FlowMods;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NxLearnBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxLearnBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxLearnBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxLearnBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxLearnBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxLearnBuilder implements Builder<NxLearn> {

    private Uint64 _cookie;
    private Uint16 _finHardTimeout;
    private Uint16 _finIdleTimeout;
    private Uint16 _flags;
    private List<FlowMods> _flowMods;
    private Uint16 _hardTimeout;
    private Uint16 _idleTimeout;
    private Uint16 _priority;
    private Uint8 _tableId;


    Map<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>> augmentation = Collections.emptyMap();

    public NxLearnBuilder() {
    }
    
    

    public NxLearnBuilder(NxLearn base) {
        Map<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._cookie = base.getCookie();
        this._finHardTimeout = base.getFinHardTimeout();
        this._finIdleTimeout = base.getFinIdleTimeout();
        this._flags = base.getFlags();
        this._flowMods = base.getFlowMods();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._priority = base.getPriority();
        this._tableId = base.getTableId();
    }


    public Uint64 getCookie() {
        return _cookie;
    }
    
    public Uint16 getFinHardTimeout() {
        return _finHardTimeout;
    }
    
    public Uint16 getFinIdleTimeout() {
        return _finIdleTimeout;
    }
    
    public Uint16 getFlags() {
        return _flags;
    }
    
    public List<FlowMods> getFlowMods() {
        return _flowMods;
    }
    
    public Uint16 getHardTimeout() {
        return _hardTimeout;
    }
    
    public Uint16 getIdleTimeout() {
        return _idleTimeout;
    }
    
    public Uint16 getPriority() {
        return _priority;
    }
    
    public Uint8 getTableId() {
        return _tableId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxLearn>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxLearnBuilder setCookie(final Uint64 value) {
        this._cookie = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setCookie(Uint64)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setCookie(final BigInteger value) {
        return setCookie(CodeHelpers.compatUint(value));
    }
    
    public NxLearnBuilder setFinHardTimeout(final Uint16 value) {
        this._finHardTimeout = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setFinHardTimeout(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setFinHardTimeout(final Integer value) {
        return setFinHardTimeout(CodeHelpers.compatUint(value));
    }
    
    public NxLearnBuilder setFinIdleTimeout(final Uint16 value) {
        this._finIdleTimeout = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setFinIdleTimeout(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setFinIdleTimeout(final Integer value) {
        return setFinIdleTimeout(CodeHelpers.compatUint(value));
    }
    
    public NxLearnBuilder setFlags(final Uint16 value) {
        this._flags = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setFlags(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setFlags(final Integer value) {
        return setFlags(CodeHelpers.compatUint(value));
    }
    public NxLearnBuilder setFlowMods(final List<FlowMods> values) {
        this._flowMods = values;
        return this;
    }
    
    
    public NxLearnBuilder setHardTimeout(final Uint16 value) {
        this._hardTimeout = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setHardTimeout(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setHardTimeout(final Integer value) {
        return setHardTimeout(CodeHelpers.compatUint(value));
    }
    
    public NxLearnBuilder setIdleTimeout(final Uint16 value) {
        this._idleTimeout = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setIdleTimeout(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setIdleTimeout(final Integer value) {
        return setIdleTimeout(CodeHelpers.compatUint(value));
    }
    
    public NxLearnBuilder setPriority(final Uint16 value) {
        this._priority = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setPriority(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setPriority(final Integer value) {
        return setPriority(CodeHelpers.compatUint(value));
    }
    
    public NxLearnBuilder setTableId(final Uint8 value) {
        this._tableId = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setTableId(Uint8)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxLearnBuilder setTableId(final Short value) {
        return setTableId(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxLearnBuilder addAugmentation(Augmentation<NxLearn> augmentation) {
        Class<? extends Augmentation<NxLearn>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxLearnBuilder removeAugmentation(Class<? extends Augmentation<NxLearn>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxLearn build() {
        return new NxLearnImpl(this);
    }

    private static final class NxLearnImpl
        extends AbstractAugmentable<NxLearn>
        implements NxLearn {
    
        private final Uint64 _cookie;
        private final Uint16 _finHardTimeout;
        private final Uint16 _finIdleTimeout;
        private final Uint16 _flags;
        private final List<FlowMods> _flowMods;
        private final Uint16 _hardTimeout;
        private final Uint16 _idleTimeout;
        private final Uint16 _priority;
        private final Uint8 _tableId;
    
        NxLearnImpl(NxLearnBuilder base) {
            super(base.augmentation);
            this._cookie = base.getCookie();
            this._finHardTimeout = base.getFinHardTimeout();
            this._finIdleTimeout = base.getFinIdleTimeout();
            this._flags = base.getFlags();
            this._flowMods = CodeHelpers.emptyToNull(base.getFlowMods());
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._priority = base.getPriority();
            this._tableId = base.getTableId();
        }
    
        @Override
        public Uint64 getCookie() {
            return _cookie;
        }
        
        @Override
        public Uint16 getFinHardTimeout() {
            return _finHardTimeout;
        }
        
        @Override
        public Uint16 getFinIdleTimeout() {
            return _finIdleTimeout;
        }
        
        @Override
        public Uint16 getFlags() {
            return _flags;
        }
        
        @Override
        public List<FlowMods> getFlowMods() {
            return _flowMods;
        }
        
        @Override
        public Uint16 getHardTimeout() {
            return _hardTimeout;
        }
        
        @Override
        public Uint16 getIdleTimeout() {
            return _idleTimeout;
        }
        
        @Override
        public Uint16 getPriority() {
            return _priority;
        }
        
        @Override
        public Uint8 getTableId() {
            return _tableId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxLearn.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxLearn.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxLearn.bindingToString(this);
        }
    }
}
