package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.value._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link FlowModAddMatchFromValueBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModAddMatchFromValueBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModAddMatchFromValueBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModAddMatchFromValueBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModAddMatchFromValueBuilder
 * @see Builder
 *
 */
public class FlowModAddMatchFromValueBuilder implements Builder<FlowModAddMatchFromValue> {

    private Uint16 _flowModNumBits;
    private Uint32 _srcField;
    private Uint16 _srcOfs;
    private Uint16 _value;


    Map<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromValueBuilder() {
    }

    public FlowModAddMatchFromValueBuilder(FlowModAddMatchFromValue base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> aug =((AugmentationHolder<FlowModAddMatchFromValue>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
        this._value = base.getValue();
    }


    public Uint16 getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Uint32 getSrcField() {
        return _srcField;
    }
    
    public Uint16 getSrcOfs() {
        return _srcOfs;
    }
    
    public Uint16 getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModAddMatchFromValue>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public FlowModAddMatchFromValueBuilder setFlowModNumBits(final Uint16 value) {
        this._flowModNumBits = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setFlowModNumBits(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModAddMatchFromValueBuilder setFlowModNumBits(final Integer value) {
        return setFlowModNumBits(CodeHelpers.compatUint(value));
    }
    
    public FlowModAddMatchFromValueBuilder setSrcField(final Uint32 value) {
        this._srcField = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setSrcField(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModAddMatchFromValueBuilder setSrcField(final Long value) {
        return setSrcField(CodeHelpers.compatUint(value));
    }
    
    public FlowModAddMatchFromValueBuilder setSrcOfs(final Uint16 value) {
        this._srcOfs = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setSrcOfs(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModAddMatchFromValueBuilder setSrcOfs(final Integer value) {
        return setSrcOfs(CodeHelpers.compatUint(value));
    }
    
    public FlowModAddMatchFromValueBuilder setValue(final Uint16 value) {
        this._value = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {@link #setValue(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModAddMatchFromValueBuilder setValue(final Integer value) {
        return setValue(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public FlowModAddMatchFromValueBuilder addAugmentation(Augmentation<FlowModAddMatchFromValue> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public FlowModAddMatchFromValueBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType, Augmentation<FlowModAddMatchFromValue> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public FlowModAddMatchFromValueBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private FlowModAddMatchFromValueBuilder doAddAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType, Augmentation<FlowModAddMatchFromValue> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public FlowModAddMatchFromValue build() {
        return new FlowModAddMatchFromValueImpl(this);
    }

    private static final class FlowModAddMatchFromValueImpl
        extends AbstractAugmentable<FlowModAddMatchFromValue>
        implements FlowModAddMatchFromValue {
    
        private final Uint16 _flowModNumBits;
        private final Uint32 _srcField;
        private final Uint16 _srcOfs;
        private final Uint16 _value;
    
        FlowModAddMatchFromValueImpl(FlowModAddMatchFromValueBuilder base) {
            super(base.augmentation);
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
            this._value = base.getValue();
        }
    
        @Override
        public Uint16 getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Uint32 getSrcField() {
            return _srcField;
        }
        
        @Override
        public Uint16 getSrcOfs() {
            return _srcOfs;
        }
        
        @Override
        public Uint16 getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_srcField);
            result = prime * result + Objects.hashCode(_srcOfs);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromValue.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModAddMatchFromValue other = (FlowModAddMatchFromValue)obj;
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(_srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromValueImpl otherImpl = (FlowModAddMatchFromValueImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromValue");
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_srcField", _srcField);
            CodeHelpers.appendValue(helper, "_srcOfs", _srcOfs);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
