package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._4.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link NxmNxNshc4Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxmNxNshc4Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxmNxNshc4BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxmNxNshc4Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxmNxNshc4Builder
 * @see Builder
 *
 */
public class NxmNxNshc4Builder implements Builder<NxmNxNshc4> {

    private Uint32 _mask;
    private Uint32 _value;


    Map<Class<? extends Augmentation<NxmNxNshc4>>, Augmentation<NxmNxNshc4>> augmentation = Collections.emptyMap();

    public NxmNxNshc4Builder() {
    }

    public NxmNxNshc4Builder(NxmNxNshc4 base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNshc4>>, Augmentation<NxmNxNshc4>> aug =((AugmentationHolder<NxmNxNshc4>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mask = base.getMask();
        this._value = base.getValue();
    }


    public Uint32 getMask() {
        return _mask;
    }
    
    public Uint32 getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshc4>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxmNxNshc4Builder setMask(final Uint32 value) {
        this._mask = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setMask(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshc4Builder setMask(final Long value) {
        return setMask(CodeHelpers.compatUint(value));
    }
    
    public NxmNxNshc4Builder setValue(final Uint32 value) {
        this._value = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setValue(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxmNxNshc4Builder setValue(final Long value) {
        return setValue(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxmNxNshc4Builder addAugmentation(Augmentation<NxmNxNshc4> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public NxmNxNshc4Builder addAugmentation(Class<? extends Augmentation<NxmNxNshc4>> augmentationType, Augmentation<NxmNxNshc4> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxmNxNshc4Builder removeAugmentation(Class<? extends Augmentation<NxmNxNshc4>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private NxmNxNshc4Builder doAddAugmentation(Class<? extends Augmentation<NxmNxNshc4>> augmentationType, Augmentation<NxmNxNshc4> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public NxmNxNshc4 build() {
        return new NxmNxNshc4Impl(this);
    }

    private static final class NxmNxNshc4Impl
        extends AbstractAugmentable<NxmNxNshc4>
        implements NxmNxNshc4 {
    
        private final Uint32 _mask;
        private final Uint32 _value;
    
        NxmNxNshc4Impl(NxmNxNshc4Builder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._value = base.getValue();
        }
    
        @Override
        public Uint32 getMask() {
            return _mask;
        }
        
        @Override
        public Uint32 getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshc4.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxmNxNshc4 other = (NxmNxNshc4)obj;
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNshc4Impl otherImpl = (NxmNxNshc4Impl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshc4>>, Augmentation<NxmNxNshc4>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNshc4");
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
