package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link NxActionNatBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionNatBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionNatBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionNatBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionNatBuilder
 * @see Builder
 *
 */
public class NxActionNatBuilder implements Builder<NxActionNat> {

    private Uint16 _flags;
    private IpAddress _ipAddressMax;
    private IpAddress _ipAddressMin;
    private Uint16 _portMax;
    private Uint16 _portMin;
    private Uint16 _rangePresent;


    Map<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> augmentation = Collections.emptyMap();

    public NxActionNatBuilder() {
    }

    public NxActionNatBuilder(NxActionNat base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> aug =((AugmentationHolder<NxActionNat>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flags = base.getFlags();
        this._ipAddressMax = base.getIpAddressMax();
        this._ipAddressMin = base.getIpAddressMin();
        this._portMax = base.getPortMax();
        this._portMin = base.getPortMin();
        this._rangePresent = base.getRangePresent();
    }


    public Uint16 getFlags() {
        return _flags;
    }
    
    public IpAddress getIpAddressMax() {
        return _ipAddressMax;
    }
    
    public IpAddress getIpAddressMin() {
        return _ipAddressMin;
    }
    
    public Uint16 getPortMax() {
        return _portMax;
    }
    
    public Uint16 getPortMin() {
        return _portMin;
    }
    
    public Uint16 getRangePresent() {
        return _rangePresent;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionNat>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionNatBuilder setFlags(final Uint16 value) {
        this._flags = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setFlags(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxActionNatBuilder setFlags(final Integer value) {
        return setFlags(CodeHelpers.compatUint(value));
    }
    
    public NxActionNatBuilder setIpAddressMax(final IpAddress value) {
        this._ipAddressMax = value;
        return this;
    }
    
    public NxActionNatBuilder setIpAddressMin(final IpAddress value) {
        this._ipAddressMin = value;
        return this;
    }
    
    public NxActionNatBuilder setPortMax(final Uint16 value) {
        this._portMax = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setPortMax(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxActionNatBuilder setPortMax(final Integer value) {
        return setPortMax(CodeHelpers.compatUint(value));
    }
    
    public NxActionNatBuilder setPortMin(final Uint16 value) {
        this._portMin = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setPortMin(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxActionNatBuilder setPortMin(final Integer value) {
        return setPortMin(CodeHelpers.compatUint(value));
    }
    
    public NxActionNatBuilder setRangePresent(final Uint16 value) {
        this._rangePresent = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setRangePresent(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public NxActionNatBuilder setRangePresent(final Integer value) {
        return setRangePresent(CodeHelpers.compatUint(value));
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionNatBuilder addAugmentation(Augmentation<NxActionNat> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public NxActionNatBuilder addAugmentation(Class<? extends Augmentation<NxActionNat>> augmentationType, Augmentation<NxActionNat> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionNatBuilder removeAugmentation(Class<? extends Augmentation<NxActionNat>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private NxActionNatBuilder doAddAugmentation(Class<? extends Augmentation<NxActionNat>> augmentationType, Augmentation<NxActionNat> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public NxActionNat build() {
        return new NxActionNatImpl(this);
    }

    private static final class NxActionNatImpl
        extends AbstractAugmentable<NxActionNat>
        implements NxActionNat {
    
        private final Uint16 _flags;
        private final IpAddress _ipAddressMax;
        private final IpAddress _ipAddressMin;
        private final Uint16 _portMax;
        private final Uint16 _portMin;
        private final Uint16 _rangePresent;
    
        NxActionNatImpl(NxActionNatBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
            this._ipAddressMax = base.getIpAddressMax();
            this._ipAddressMin = base.getIpAddressMin();
            this._portMax = base.getPortMax();
            this._portMin = base.getPortMin();
            this._rangePresent = base.getRangePresent();
        }
    
        @Override
        public Uint16 getFlags() {
            return _flags;
        }
        
        @Override
        public IpAddress getIpAddressMax() {
            return _ipAddressMax;
        }
        
        @Override
        public IpAddress getIpAddressMin() {
            return _ipAddressMin;
        }
        
        @Override
        public Uint16 getPortMax() {
            return _portMax;
        }
        
        @Override
        public Uint16 getPortMin() {
            return _portMin;
        }
        
        @Override
        public Uint16 getRangePresent() {
            return _rangePresent;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flags);
            result = prime * result + Objects.hashCode(_ipAddressMax);
            result = prime * result + Objects.hashCode(_ipAddressMin);
            result = prime * result + Objects.hashCode(_portMax);
            result = prime * result + Objects.hashCode(_portMin);
            result = prime * result + Objects.hashCode(_rangePresent);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionNat.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionNat other = (NxActionNat)obj;
            if (!Objects.equals(_flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(_ipAddressMax, other.getIpAddressMax())) {
                return false;
            }
            if (!Objects.equals(_ipAddressMin, other.getIpAddressMin())) {
                return false;
            }
            if (!Objects.equals(_portMax, other.getPortMax())) {
                return false;
            }
            if (!Objects.equals(_portMin, other.getPortMin())) {
                return false;
            }
            if (!Objects.equals(_rangePresent, other.getRangePresent())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionNatImpl otherImpl = (NxActionNatImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionNat>>, Augmentation<NxActionNat>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionNat");
            CodeHelpers.appendValue(helper, "_flags", _flags);
            CodeHelpers.appendValue(helper, "_ipAddressMax", _ipAddressMax);
            CodeHelpers.appendValue(helper, "_ipAddressMin", _ipAddressMin);
            CodeHelpers.appendValue(helper, "_portMax", _portMax);
            CodeHelpers.appendValue(helper, "_portMin", _portMin);
            CodeHelpers.appendValue(helper, "_rangePresent", _rangePresent);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
