package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.dec.nsh.ttl.grouping.NxDecNshTtl;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder
 * @see Builder
 *
 */
public class NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase> {

    private NxDecNshTtl _nxDecNshTtl;


    Map<Class<? extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping arg) {
        this._nxDecNshTtl = arg.getNxDecNshTtl();
    }

    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder(NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxDecNshTtl = base.getNxDecNshTtl();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping) {
            this._nxDecNshTtl = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping)arg).getNxDecNshTtl();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecNshTtlGrouping]");
    }

    public NxDecNshTtl getNxDecNshTtl() {
        return _nxDecNshTtl;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder setNxDecNshTtl(final NxDecNshTtl value) {
        this._nxDecNshTtl = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder doAddAugmentation(Class<? extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase build() {
        return new NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>
        implements NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase {
    
        private final NxDecNshTtl _nxDecNshTtl;
    
        NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseImpl(NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxDecNshTtl = base.getNxDecNshTtl();
        }
    
        @Override
        public NxDecNshTtl getNxDecNshTtl() {
            return _nxDecNshTtl;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecNshTtl);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase other = (NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxDecNshTtl, other.getNxDecNshTtl())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecNshTtlNotifFlowsStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxDecNshTtl", _nxDecNshTtl);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
