/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionToOFJava;
import org.opendaylight.openflowplugin.extension.api.path.ActionPath;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action.ActionUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionConntrackBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping.NxActionConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping.NxActionConntrackBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping.nx.action.conntrack.CtActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping.nx.action.conntrack.CtActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.NxActionCtMarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionConntrackNotifFlowsStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionConntrackNotifDirectStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action.NxActionConntrackNotifGroupDescStatsUpdatedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionConntrackNodesNodeTableFlowApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionConntrackNodesNodeTableFlowWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrackBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.OfpactActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.NxActionCtMarkCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.NxActionNatCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.NxActionNatCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNatBuilder;

public class ConntrackConvertor
implements ConvertorActionToOFJava<org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action, Action>,
ConvertorActionFromOFJava<Action, ActionPath> {
    public org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action convert(Action input, ActionPath path) {
        NxActionConntrack action = ((ActionConntrack)input.getActionChoice()).getNxActionConntrack();
        NxConntrackBuilder builder = new NxConntrackBuilder();
        builder.setFlags(action.getFlags());
        builder.setZoneSrc(action.getZoneSrc());
        builder.setRecircTable(action.getRecircTable());
        builder.setConntrackZone(action.getConntrackZone());
        builder.setCtActions(this.getCtAction(action));
        return ConntrackConvertor.resolveAction(builder.build(), path);
    }

    public Action convert(org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action nxActionArg) {
        Preconditions.checkArgument((boolean)(nxActionArg instanceof NxActionConntrackGrouping));
        NxActionConntrackGrouping nxAction = (NxActionConntrackGrouping)nxActionArg;
        NxActionConntrackBuilder nxActionConntrackBuilder = new NxActionConntrackBuilder();
        nxActionConntrackBuilder.setFlags(nxAction.getNxConntrack().getFlags());
        nxActionConntrackBuilder.setZoneSrc(nxAction.getNxConntrack().getZoneSrc());
        nxActionConntrackBuilder.setRecircTable(nxAction.getNxConntrack().getRecircTable());
        nxActionConntrackBuilder.setConntrackZone(nxAction.getNxConntrack().getConntrackZone());
        nxActionConntrackBuilder.setCtActions(this.getCtAction(nxAction.getNxConntrack()));
        ActionConntrackBuilder actionConntrackBuilder = new ActionConntrackBuilder();
        actionConntrackBuilder.setNxActionConntrack(nxActionConntrackBuilder.build());
        return ActionUtil.createAction((ActionChoice)actionConntrackBuilder.build());
    }

    private static org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action resolveAction(NxConntrack value, ActionPath path) {
        switch (path) {
            case INVENTORY_FLOWNODE_TABLE_WRITE_ACTIONS: {
                return new NxActionConntrackNodesNodeTableFlowWriteActionsCaseBuilder().setNxConntrack(value).build();
            }
            case FLOWS_STATISTICS_UPDATE_WRITE_ACTIONS: {
                return new NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder().setNxConntrack(value).build();
            }
            case FLOWS_STATISTICS_UPDATE_APPLY_ACTIONS: {
                return new NxActionConntrackNotifFlowsStatisticsUpdateApplyActionsCaseBuilder().setNxConntrack(value).build();
            }
            case GROUP_DESC_STATS_UPDATED_BUCKET_ACTION: {
                return new NxActionConntrackNotifGroupDescStatsUpdatedCaseBuilder().setNxConntrack(value).build();
            }
            case FLOWS_STATISTICS_RPC_WRITE_ACTIONS: {
                return new NxActionConntrackNotifDirectStatisticsUpdateWriteActionsCaseBuilder().setNxConntrack(value).build();
            }
            case FLOWS_STATISTICS_RPC_APPLY_ACTIONS: {
                return new NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder().setNxConntrack(value).build();
            }
            case INVENTORY_FLOWNODE_TABLE_APPLY_ACTIONS: {
                return new NxActionConntrackNodesNodeTableFlowApplyActionsCaseBuilder().setNxConntrack(value).build();
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }

    private List<CtActions> getCtAction(NxConntrack action) {
        if (action.getCtActions() == null) {
            return null;
        }
        ArrayList<CtActions> ctActions = new ArrayList<CtActions>();
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions ctAction : action.getCtActions()) {
            CtActionsBuilder ctActionsBuilder;
            NxActionCtMarkCaseBuilder caseBuilder;
            OfpactActions ofpactAction = ctAction.getOfpactActions();
            if (ofpactAction instanceof NxActionNatCase) {
                org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat nxActionNat = ((NxActionNatCase)ofpactAction).getNxActionNat();
                org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNatBuilder nxActionNatBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNatBuilder();
                nxActionNatBuilder.setFlags(nxActionNat.getFlags());
                nxActionNatBuilder.setRangePresent(nxActionNat.getRangePresent());
                nxActionNatBuilder.setIpAddressMin(nxActionNat.getIpAddressMin());
                nxActionNatBuilder.setIpAddressMax(nxActionNat.getIpAddressMax());
                nxActionNatBuilder.setPortMin(nxActionNat.getPortMin());
                nxActionNatBuilder.setPortMax(nxActionNat.getPortMax());
                caseBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.NxActionNatCaseBuilder();
                caseBuilder.setNxActionNat(nxActionNatBuilder.build());
                ctActionsBuilder = new CtActionsBuilder();
                ctActionsBuilder.setOfpactActions((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.OfpactActions)caseBuilder.build());
                ctActions.add(ctActionsBuilder.build());
                continue;
            }
            if (!(ofpactAction instanceof NxActionCtMarkCase)) continue;
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMark nxActionCtMark = ((NxActionCtMarkCase)ofpactAction).getNxActionCtMark();
            NxActionCtMarkBuilder nxActionCtMarkBuilder = new NxActionCtMarkBuilder();
            nxActionCtMarkBuilder.setCtMark(nxActionCtMark.getCtMark());
            caseBuilder = new NxActionCtMarkCaseBuilder();
            caseBuilder.setNxActionCtMark(nxActionCtMarkBuilder.build());
            ctActionsBuilder = new CtActionsBuilder();
            ctActionsBuilder.setOfpactActions((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.OfpactActions)caseBuilder.build());
            ctActions.add(ctActionsBuilder.build());
        }
        return ctActions;
    }

    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions> getCtAction(NxActionConntrack action) {
        if (action.getCtActions() == null) {
            return null;
        }
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions> ctActions = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions>();
        for (CtActions ctAction : action.getCtActions()) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActionsBuilder ctActionsBuilder;
            Object caseBuilder;
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.OfpactActions ofpactAction = ctAction.getOfpactActions();
            if (ofpactAction instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.NxActionNatCase) {
                NxActionNat nxActionNat = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.NxActionNatCase)ofpactAction).getNxActionNat();
                NxActionNatBuilder nxActionNatBuilder = new NxActionNatBuilder();
                nxActionNatBuilder.setFlags(nxActionNat.getFlags());
                nxActionNatBuilder.setRangePresent(nxActionNat.getRangePresent());
                nxActionNatBuilder.setIpAddressMin(nxActionNat.getIpAddressMin());
                nxActionNatBuilder.setIpAddressMax(nxActionNat.getIpAddressMax());
                nxActionNatBuilder.setPortMin(nxActionNat.getPortMin());
                nxActionNatBuilder.setPortMax(nxActionNat.getPortMax());
                caseBuilder = new NxActionNatCaseBuilder();
                ((NxActionNatCaseBuilder)caseBuilder).setNxActionNat(nxActionNatBuilder.build());
                ctActionsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActionsBuilder();
                ctActionsBuilder.setOfpactActions(((NxActionNatCaseBuilder)caseBuilder).build());
                ctActions.add(ctActionsBuilder.build());
                continue;
            }
            if (!(ofpactAction instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.NxActionCtMarkCase)) continue;
            NxActionCtMark nxActionCtMark = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofpact.actions.ofpact.actions.NxActionCtMarkCase)ofpactAction).getNxActionCtMark();
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMarkBuilder nxActionCtMarkBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMarkBuilder();
            nxActionCtMarkBuilder.setCtMark(nxActionCtMark.getCtMark());
            caseBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.NxActionCtMarkCaseBuilder();
            ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.NxActionCtMarkCaseBuilder)caseBuilder).setNxActionCtMark(nxActionCtMarkBuilder.build());
            ctActionsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActionsBuilder();
            ctActionsBuilder.setOfpactActions(((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.NxActionCtMarkCaseBuilder)caseBuilder).build());
            ctActions.add(ctActionsBuilder.build());
        }
        return ctActions;
    }
}

