package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.copy.value.into.field._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link FlowModCopyValueIntoFieldBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModCopyValueIntoFieldBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModCopyValueIntoFieldBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModCopyValueIntoFieldBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModCopyValueIntoFieldBuilder
 * @see Builder
 *
 */
public class FlowModCopyValueIntoFieldBuilder implements Builder<FlowModCopyValueIntoField> {

    private Uint32 _dstField;
    private Uint16 _dstOfs;
    private Uint16 _flowModNumBits;
    private Uint16 _value;


    Map<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> augmentation = Collections.emptyMap();

    public FlowModCopyValueIntoFieldBuilder() {
    }

    public FlowModCopyValueIntoFieldBuilder(FlowModCopyValueIntoField base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> aug =((AugmentationHolder<FlowModCopyValueIntoField>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._dstField = base.getDstField();
        this._dstOfs = base.getDstOfs();
        this._flowModNumBits = base.getFlowModNumBits();
        this._value = base.getValue();
    }


    public Uint32 getDstField() {
        return _dstField;
    }
    
    public Uint16 getDstOfs() {
        return _dstOfs;
    }
    
    public Uint16 getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Uint16 getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModCopyValueIntoField>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModCopyValueIntoFieldBuilder setDstField(final Uint32 value) {
        this._dstField = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setDstField(Uint32)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModCopyValueIntoFieldBuilder setDstField(final Long value) {
        return setDstField(CodeHelpers.compatUint(value));
    }
    
    public FlowModCopyValueIntoFieldBuilder setDstOfs(final Uint16 value) {
        this._dstOfs = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setDstOfs(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModCopyValueIntoFieldBuilder setDstOfs(final Integer value) {
        return setDstOfs(CodeHelpers.compatUint(value));
    }
    
    public FlowModCopyValueIntoFieldBuilder setFlowModNumBits(final Uint16 value) {
        this._flowModNumBits = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setFlowModNumBits(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModCopyValueIntoFieldBuilder setFlowModNumBits(final Integer value) {
        return setFlowModNumBits(CodeHelpers.compatUint(value));
    }
    
    public FlowModCopyValueIntoFieldBuilder setValue(final Uint16 value) {
        this._value = value;
        return this;
    }
    
    /**
     * Utility migration setter.
     *
     * @param value field value in legacy type
     * @return this builder
     * @deprecated Use {#link setValue(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public FlowModCopyValueIntoFieldBuilder setValue(final Integer value) {
        return setValue(CodeHelpers.compatUint(value));
    }
    
    public FlowModCopyValueIntoFieldBuilder addAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoField>> augmentationType, Augmentation<FlowModCopyValueIntoField> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModCopyValueIntoFieldBuilder removeAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoField>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModCopyValueIntoField build() {
        return new FlowModCopyValueIntoFieldImpl(this);
    }

    private static final class FlowModCopyValueIntoFieldImpl
        extends AbstractAugmentable<FlowModCopyValueIntoField>
        implements FlowModCopyValueIntoField {
    
        private final Uint32 _dstField;
        private final Uint16 _dstOfs;
        private final Uint16 _flowModNumBits;
        private final Uint16 _value;
    
        FlowModCopyValueIntoFieldImpl(FlowModCopyValueIntoFieldBuilder base) {
            super(base.augmentation);
            this._dstField = base.getDstField();
            this._dstOfs = base.getDstOfs();
            this._flowModNumBits = base.getFlowModNumBits();
            this._value = base.getValue();
        }
    
        @Override
        public Uint32 getDstField() {
            return _dstField;
        }
        
        @Override
        public Uint16 getDstOfs() {
            return _dstOfs;
        }
        
        @Override
        public Uint16 getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Uint16 getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstField);
            result = prime * result + Objects.hashCode(_dstOfs);
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModCopyValueIntoField.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModCopyValueIntoField other = (FlowModCopyValueIntoField)obj;
            if (!Objects.equals(_dstField, other.getDstField())) {
                return false;
            }
            if (!Objects.equals(_dstOfs, other.getDstOfs())) {
                return false;
            }
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModCopyValueIntoFieldImpl otherImpl = (FlowModCopyValueIntoFieldImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModCopyValueIntoField");
            CodeHelpers.appendValue(helper, "_dstField", _dstField);
            CodeHelpers.appendValue(helper, "_dstOfs", _dstOfs);
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
