package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case.FlowModOutputToPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModOutputToPortCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModOutputToPortCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModOutputToPortCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModOutputToPortCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModOutputToPortCaseBuilder
 * @see Builder
 *
 */
public class FlowModOutputToPortCaseBuilder implements Builder<FlowModOutputToPortCase> {

    private FlowModOutputToPort _flowModOutputToPort;


    Map<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> augmentation = Collections.emptyMap();

    public FlowModOutputToPortCaseBuilder() {
    }

    public FlowModOutputToPortCaseBuilder(FlowModOutputToPortCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> aug =((AugmentationHolder<FlowModOutputToPortCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModOutputToPort = base.getFlowModOutputToPort();
    }


    public FlowModOutputToPort getFlowModOutputToPort() {
        return _flowModOutputToPort;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModOutputToPortCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModOutputToPortCaseBuilder setFlowModOutputToPort(final FlowModOutputToPort value) {
        this._flowModOutputToPort = value;
        return this;
    }
    
    public FlowModOutputToPortCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModOutputToPortCase>> augmentationType, Augmentation<FlowModOutputToPortCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModOutputToPortCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModOutputToPortCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModOutputToPortCase build() {
        return new FlowModOutputToPortCaseImpl(this);
    }

    private static final class FlowModOutputToPortCaseImpl
        extends AbstractAugmentable<FlowModOutputToPortCase>
        implements FlowModOutputToPortCase {
    
        private final FlowModOutputToPort _flowModOutputToPort;
    
        FlowModOutputToPortCaseImpl(FlowModOutputToPortCaseBuilder base) {
            super(base.augmentation);
            this._flowModOutputToPort = base.getFlowModOutputToPort();
        }
    
        @Override
        public FlowModOutputToPort getFlowModOutputToPort() {
            return _flowModOutputToPort;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModOutputToPort);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModOutputToPortCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModOutputToPortCase other = (FlowModOutputToPortCase)obj;
            if (!Objects.equals(_flowModOutputToPort, other.getFlowModOutputToPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModOutputToPortCaseImpl otherImpl = (FlowModOutputToPortCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModOutputToPortCase>>, Augmentation<FlowModOutputToPortCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModOutputToPortCase");
            CodeHelpers.appendValue(helper, "_flowModOutputToPort", _flowModOutputToPort);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
